/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.impl.EObjectIntegerMapEntryImpl;
import org.eclipse.emf.henshin.statespace.impl.EObjectIntegerMapImpl;
import org.eclipse.emf.henshin.statespace.util.ObjectKeyHelper;

public class ModelImpl
extends MinimalEObjectImpl.Container
implements Model {
    protected static final Resource RESOURCE_EDEFAULT = null;
    protected Resource resource = RESOURCE_EDEFAULT;
    protected static final EGraph EGRAPH_EDEFAULT = null;
    protected EGraph eGraph = EGRAPH_EDEFAULT;
    protected EMap<EObject, Integer> objectHashCodes;
    protected EMap<EObject, Integer> objectKeysMap;
    protected static final int[] OBJECT_KEYS_EDEFAULT = null;
    protected static final int OBJECT_COUNT_EDEFAULT = 0;

    public ModelImpl(Resource resource) {
        this.resource = resource;
    }

    public ModelImpl(Resource resource, EGraph eGraph) {
        this.resource = resource;
        this.eGraph = eGraph;
    }

    @Override
    public EGraph getEGraph() {
        if (this.eGraph == null) {
            this.eGraph = InterpreterFactory.INSTANCE.createEGraph();
            for (EObject root : this.resource.getContents()) {
                this.eGraph.addTree(root);
            }
        }
        return this.eGraph;
    }

    @Override
    public EMap<EObject, Integer> getObjectHashCodes() {
        if (this.objectHashCodes == null) {
            this.objectHashCodes = new EObjectIntegerMapImpl(StateSpacePackage.Literals.EOBJECT_INTEGER_MAP_ENTRY, EObjectIntegerMapEntryImpl.class, (InternalEObject)this, 2);
        }
        return this.objectHashCodes;
    }

    @Override
    public EMap<EObject, Integer> getObjectKeysMap() {
        if (this.objectKeysMap == null) {
            this.objectKeysMap = new EObjectIntegerMapImpl(StateSpacePackage.Literals.EOBJECT_INTEGER_MAP_ENTRY, EObjectIntegerMapEntryImpl.class, (InternalEObject)this, 3);
        }
        return this.objectKeysMap;
    }

    @Override
    public Model getCopy(Match match) {
        EObject object;
        TreeIterator iterator;
        ResourceImpl copiedResource = new ResourceImpl();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        copiedResource.getContents().addAll(copier.copyAll((Collection)this.resource.getContents()));
        copier.copyReferences();
        if (match != null) {
            this.updateMatch(match, copier);
        }
        EGraph copiedGraph = null;
        if (this.eGraph != null) {
            copiedGraph = this.eGraph.copy((Map)copier);
        }
        ModelImpl copy = new ModelImpl((Resource)copiedResource, copiedGraph);
        if (this.objectKeysMap != null) {
            iterator = this.resource.getAllContents();
            while (iterator.hasNext()) {
                object = (EObject)iterator.next();
                copy.getObjectKeysMap().put((Object)((EObject)copier.get((Object)object)), (Object)((Integer)this.objectKeysMap.get((Object)object)));
            }
        }
        if (this.objectHashCodes != null) {
            iterator = this.resource.getAllContents();
            while (iterator.hasNext()) {
                object = (EObject)iterator.next();
                copy.getObjectHashCodes().put((Object)((EObject)copier.get((Object)object)), (Object)((Integer)this.objectHashCodes.get((Object)object)));
            }
        }
        return copy;
    }

    private void updateMatch(Match match, EcoreUtil.Copier copier) {
        for (Node node : match.getRule().getLhs().getNodes()) {
            EObject newImage = (EObject)copier.get((Object)match.getNodeTarget(node));
            match.setNodeTarget(node, newImage);
        }
        for (Rule rule : match.getRule().getMultiRules()) {
            for (Match nested : match.getNestedMatches(rule)) {
                this.updateMatch(nested, copier);
            }
        }
    }

    @Override
    public boolean updateObjectKeys(EList<EClass> identityTypes) {
        this.getObjectKeysMap();
        boolean changed = false;
        int nextFreeId = this.getNextFreeId();
        TreeIterator iterator = this.resource.getAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            int currentId = ObjectKeyHelper.getObjectID((Integer)this.objectKeysMap.get((Object)object));
            if (currentId == 0 && identityTypes.contains((Object)object.eClass())) {
                int objectKey = ObjectKeyHelper.createObjectKey(object.eClass(), nextFreeId++, identityTypes);
                this.objectKeysMap.put((Object)object, (Object)objectKey);
                changed = true;
                continue;
            }
            if (currentId == 0 || identityTypes.contains((Object)object.eClass())) continue;
            this.objectKeysMap.remove((Object)object);
            changed = true;
        }
        return changed;
    }

    private int getNextFreeId() {
        this.getObjectKeysMap();
        int nextFreeId = 1;
        TreeIterator iterator = this.resource.getAllContents();
        while (iterator.hasNext()) {
            int id = ObjectKeyHelper.getObjectID((Integer)this.objectKeysMap.get(iterator.next()));
            if (id < nextFreeId) continue;
            nextFreeId = id + 1;
        }
        return nextFreeId;
    }

    @Override
    public void collectMissingRootObjects() {
        if (this.eGraph != null) {
            for (EObject root : this.eGraph.getRoots()) {
                if (this.resource.getContents().contains((Object)root)) continue;
                System.out.println("Warning: collected missing root object");
                this.resource.getContents().add((Object)root);
            }
        }
    }

    @Override
    public int[] getObjectKeys() {
        this.getObjectKeysMap();
        ArrayList<Integer> objectKeys = new ArrayList<Integer>(24);
        TreeIterator iterator = this.resource.getAllContents();
        while (iterator.hasNext()) {
            objectKeys.add((Integer)this.objectKeysMap.get(iterator.next()));
        }
        int[] result = new int[objectKeys.size()];
        int i = 0;
        while (i < objectKeys.size()) {
            result[i] = (Integer)objectKeys.get(i);
            ++i;
        }
        return result;
    }

    @Override
    public void setObjectKeys(int[] objectKeys) {
        this.getObjectKeysMap().clear();
        TreeIterator iterator = this.resource.getAllContents();
        int index = 0;
        while (iterator.hasNext() && index < objectKeys.length) {
            EObject object = (EObject)iterator.next();
            int key = objectKeys[index++];
            this.objectKeysMap.put((Object)object, (Object)key);
        }
    }

    @Override
    public int getObjectCount() {
        if (this.eGraph == null) {
            this.getEGraph();
        }
        return this.eGraph.size();
    }

    protected ModelImpl() {
    }

    protected EClass eStaticClass() {
        return StateSpacePackage.Literals.MODEL;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getObjectHashCodes()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getObjectKeysMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getResource();
            }
            case 1: {
                return this.getEGraph();
            }
            case 2: {
                if (coreType) {
                    return this.getObjectHashCodes();
                }
                return this.getObjectHashCodes().map();
            }
            case 3: {
                if (coreType) {
                    return this.getObjectKeysMap();
                }
                return this.getObjectKeysMap().map();
            }
            case 4: {
                return this.getObjectKeys();
            }
            case 5: {
                return this.getObjectCount();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                ((EStructuralFeature.Setting)this.getObjectHashCodes()).set(newValue);
                return;
            }
            case 3: {
                ((EStructuralFeature.Setting)this.getObjectKeysMap()).set(newValue);
                return;
            }
            case 4: {
                this.setObjectKeys((int[])newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getObjectHashCodes().clear();
                return;
            }
            case 3: {
                this.getObjectKeysMap().clear();
                return;
            }
            case 4: {
                this.setObjectKeys(OBJECT_KEYS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return RESOURCE_EDEFAULT == null ? this.resource != null : !RESOURCE_EDEFAULT.equals(this.resource);
            }
            case 1: {
                return EGRAPH_EDEFAULT == null ? this.eGraph != null : !EGRAPH_EDEFAULT.equals((Object)this.eGraph);
            }
            case 2: {
                return this.objectHashCodes != null && !this.objectHashCodes.isEmpty();
            }
            case 3: {
                return this.objectKeysMap != null && !this.objectKeysMap.isEmpty();
            }
            case 4: {
                return OBJECT_KEYS_EDEFAULT == null ? this.getObjectKeys() != null : !OBJECT_KEYS_EDEFAULT.equals(this.getObjectKeys());
            }
            case 5: {
                return this.getObjectCount() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (resource: ");
        result.append(this.resource);
        result.append(", eGraph: ");
        result.append(this.eGraph);
        result.append(')');
        return result.toString();
    }
}

