/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ApplicationCondition;
import org.eclipse.emf.henshin.interpreter.matching.conditions.AttributeConditionHandler;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Solution;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class SolutionFinder
extends ApplicationCondition {
    protected final AttributeConditionHandler conditionHandler;
    protected List<Solution> solutions;

    public SolutionFinder(EGraph graph, Map<Variable, DomainSlot> variableDomainMap, AttributeConditionHandler conditionHandler) {
        super(graph, variableDomainMap);
        this.conditionHandler = conditionHandler;
    }

    public boolean findSolution() {
        boolean matchIsPossible = false;
        if (this.solutions == null) {
            this.solutions = new ArrayList<Solution>();
            matchIsPossible = true;
        } else {
            int varCount = this.variables.size();
            int i = varCount - 1;
            while (i >= 0) {
                Variable var = (Variable)this.variables.get(i);
                if (((DomainSlot)this.domainMap.get(var)).unlock(var)) {
                    matchIsPossible = true;
                    break;
                }
                ((DomainSlot)this.domainMap.get(var)).clear(var);
                --i;
            }
        }
        if (matchIsPossible) {
            boolean success = this.findGraph();
            if (success) {
                this.solutions.add(new Solution(this.variables, this.domainMap, this.conditionHandler));
            }
            return success;
        }
        return false;
    }

    public Solution getNextSolution() {
        if (this.findSolution()) {
            return this.solutions.get(this.solutions.size() - 1);
        }
        return null;
    }

    public List<Solution> getAllSolutions() {
        while (this.getNextSolution() != null) {
        }
        return this.solutions;
    }
}

