/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeActionEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeTypeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.TransformationSystemListener;
import org.eclipse.emf.henshin.diagram.edit.policies.EdgeItemSemanticEditPolicy;
import org.eclipse.emf.henshin.diagram.providers.ActionColorProvider;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.HenshinActionHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;

public class EdgeEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4001;
    private TransformationSystemListener transformationListener;

    public EdgeEditPart(View view) {
        super(view);
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        View view = this.getNotationView();
        if (view == null) {
            return;
        }
        Edge edge = (Edge)this.getNotationView().getElement();
        if (edge == null) {
            return;
        }
        Rule rule = edge.getGraph().getContainerRule();
        if (rule == null) {
            return;
        }
        TransformationSystem system = rule.getTransformationSystem();
        this.transformationListener = new TransformationSystemListener(system, (Adapter)new AdapterImpl(){

            public void notifyChanged(Notification event) {
                if (EdgeEditPart.this.isActive() && EdgeEditPart.this.getNotationView().getElement() instanceof Edge && EdgeEditPart.this.getParent() != null) {
                    EdgeEditPart.this.refreshVisuals();
                }
            }
        });
    }

    public void removeSemanticListeners() {
        super.removeSemanticListeners();
        if (this.transformationListener != null) {
            this.transformationListener.dispose();
            this.transformationListener = null;
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new EdgeItemSemanticEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EdgeTypeEditPart) {
            ((EdgeTypeEditPart)childEditPart).setLabel(this.getPrimaryShape().getEdgeTypeLabel());
            return true;
        }
        if (childEditPart instanceof EdgeActionEditPart) {
            ((EdgeActionEditPart)childEditPart).setLabel(this.getPrimaryShape().getEdgeActionLabel());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, index);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EdgeTypeEditPart) {
            return true;
        }
        return childEditPart instanceof EdgeActionEditPart;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new EdgeFigure();
    }

    public EdgeFigure getPrimaryShape() {
        return (EdgeFigure)this.getFigure();
    }

    public void refreshForegroundColor() {
        Edge edge = (Edge)this.getNotationView().getElement();
        Action action = HenshinActionHelper.getAction((Edge)edge);
        if (action != null) {
            this.setForegroundColor(ActionColorProvider.getColor(action));
        } else {
            super.refreshForegroundColor();
        }
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        Edge edge = (Edge)this.getNotationView().getElement();
        EReference type = edge.getType();
        if (type != null) {
            if (type.isContainment()) {
                this.getPrimaryShape().setSourceDecoration(this.createDiamondDecoration());
            } else if (type.getEOpposite() != null) {
                this.getPrimaryShape().setSourceDecoration(null);
            } else {
                this.getPrimaryShape().setSourceDecoration(null);
            }
            this.getPrimaryShape().setTargetDecoration(this.createArrowDecoration());
        } else {
            this.getPrimaryShape().setSourceDecoration(null);
            this.getPrimaryShape().setTargetDecoration(null);
        }
    }

    private RotatableDecoration createDiamondDecoration() {
        PolygonDecoration df = new PolygonDecoration();
        PointList pl = new PointList();
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(1));
        pl.addPoint(this.getMapMode().DPtoLP(0), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(-1));
        pl.addPoint(this.getMapMode().DPtoLP(-2), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(1));
        df.setTemplate(pl);
        df.setScale((double)this.getMapMode().DPtoLP(7), (double)this.getMapMode().DPtoLP(3));
        return df;
    }

    private RotatableDecoration createArrowDecoration() {
        PolylineDecoration df = new PolylineDecoration();
        df.setLineWidth(1);
        return df;
    }

    public class EdgeFigure
    extends PolylineConnectionEx {
        private WrappingLabel fEdgeTypeLabel;
        private WrappingLabel fEdgeActionLabel;

        public EdgeFigure() {
            this.createContents();
        }

        private void createContents() {
            this.fEdgeTypeLabel = new WrappingLabel();
            this.fEdgeTypeLabel.setText("unknown");
            this.add((IFigure)this.fEdgeTypeLabel);
            this.fEdgeActionLabel = new WrappingLabel();
            this.fEdgeActionLabel.setText("unknown");
            this.add((IFigure)this.fEdgeActionLabel);
        }

        public WrappingLabel getEdgeTypeLabel() {
            return this.fEdgeTypeLabel;
        }

        public WrappingLabel getEdgeActionLabel() {
            return this.fEdgeActionLabel;
        }
    }
}

