/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.EClassComparator;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.TransformationSystemEditHelper;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.diagram.part.Messages;
import org.eclipse.emf.henshin.diagram.providers.ActionColorProvider;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.ActionType;
import org.eclipse.emf.henshin.model.actions.HenshinActionHelper;
import org.eclipse.emf.henshin.presentation.HenshinIcons;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NodeCreateCommand
extends EditElementCommand {
    private static final Comparator<EClassifier> ECLASS_COMPARATOR = new EClassComparator();
    private static final ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            return ((EClassifier)element).getName();
        }

        public Image getImage(Object element) {
            return HenshinIcons.ECLASS;
        }
    };
    private final Shell shell = HenshinDiagramEditorPlugin.getInstance().getWorkbench().getDisplay().getActiveShell();

    public NodeCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Rule rule = (Rule)this.getElementToEdit();
        if (rule.getLhs() == null) {
            Graph lhs = HenshinFactory.eINSTANCE.createGraph();
            lhs.setName("LHS");
            rule.setLhs(lhs);
        }
        if (rule.getRhs() == null) {
            Graph rhs = HenshinFactory.eINSTANCE.createGraph();
            rhs.setName("RHS");
            rule.setRhs(rhs);
        }
        Node lhsNode = HenshinFactory.eINSTANCE.createNode();
        Node rhsNode = HenshinFactory.eINSTANCE.createNode();
        rule.getLhs().getNodes().add((Object)lhsNode);
        rule.getRhs().getNodes().add((Object)rhsNode);
        Mapping mapping = HenshinFactory.eINSTANCE.createMapping();
        mapping.setOrigin(lhsNode);
        mapping.setImage(rhsNode);
        rule.getMappings().add((Object)mapping);
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        Object type = request.getParameter("eclass_node_type");
        TransformationSystem ts = rule.getTransformationSystem();
        SingleEClassifierSelectionDialog dialog = null;
        if (type == null) {
            dialog = new SingleEClassifierSelectionDialog(ts);
            type = dialog.openAndReturnSelection();
        }
        if (type == null || !(type instanceof EClass)) {
            return CommandResult.newCancelledCommandResult();
        }
        EClass eclass = (EClass)type;
        lhsNode.setType(eclass);
        rhsNode.setType(eclass);
        View ruleView = RootObjectEditHelper.findRuleView(rule);
        RootObjectEditHelper.updateRootContainment(ruleView, lhsNode);
        if (dialog != null) {
            HenshinActionHelper.setAction((Node)lhsNode, (Action)dialog.getAction());
        }
        this.doConfigure(lhsNode, monitor, info);
        request.setNewElement((EObject)lhsNode);
        return CommandResult.newOKCommandResult((Object)lhsNode);
    }

    protected void doConfigure(Node newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    private final class SingleEClassifierSelectionDialog
    extends ElementListSelectionDialog {
        final TransformationSystem ts;
        private Action action;

        public SingleEClassifierSelectionDialog(TransformationSystem ts) {
            super(NodeCreateCommand.this.shell, labelProvider);
            this.setMultipleSelection(false);
            this.setBlockOnOpen(true);
            this.setTitle(Messages.SingleEClassifierSelectionDialog_title);
            this.setMessage(Messages.SingleEClassifierSelectionDialog_msg);
            this.ts = ts;
            this.action = null;
        }

        public final EClassifier openAndReturnSelection() {
            List<EClassifier> elements = TransformationSystemEditHelper.collectAllEClassifier(this.ts);
            EClassifier result = null;
            if (elements.size() > 0) {
                Collections.sort(elements, ECLASS_COMPARATOR);
                this.setElements(elements.toArray());
                int returnCode = this.open();
                if (returnCode == 0) {
                    result = (EClassifier)this.getFirstResult();
                }
            }
            return result;
        }

        protected Control createDialogArea(Composite parent) {
            Composite contents = (Composite)super.createDialogArea(parent);
            Group group = new Group(contents, 0);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 3;
            group.setLayoutData((Object)data);
            group.setFont(parent.getFont());
            group.setText("Action");
            group.setLayout((Layout)new GridLayout(2, false));
            this.createLabel("Action Type:", (Composite)group);
            Composite buttons = new Composite((Composite)group, 0);
            buttons.setLayout((Layout)new RowLayout(256));
            boolean first = true;
            ActionType[] actionTypeArray = ActionType.values();
            int n = actionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionType type = actionTypeArray[n2];
                final Action current = new Action(type, new String[0]);
                Button button = new Button(buttons, 16);
                button.setText(type.toString());
                button.setForeground(ActionColorProvider.getColor(current));
                if (first) {
                    button.setSelection(true);
                    this.action = current;
                }
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        SingleEClassifierSelectionDialog.this.action = current;
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                first = false;
                ++n2;
            }
            this.createLabel("Amalgamated:", (Composite)group);
            final Button amalgamated = new Button((Composite)group, 32);
            amalgamated.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SingleEClassifierSelectionDialog.this.action = new Action(SingleEClassifierSelectionDialog.this.action.getType(), amalgamated.getSelection(), SingleEClassifierSelectionDialog.this.action.getArguments());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.createLabel("Arguments:", (Composite)group);
            final Text args = new Text((Composite)group, 2052);
            args.setLayoutData((Object)new GridData(768));
            args.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String[] parsed = args.getText().split(",");
                    SingleEClassifierSelectionDialog.this.action = new Action(SingleEClassifierSelectionDialog.this.action.getType(), SingleEClassifierSelectionDialog.this.action.isAmalgamated(), parsed);
                }
            });
            return contents;
        }

        private Label createLabel(String label, Composite grid) {
            Label l = new Label(grid, 0);
            l.setText(label);
            l.setLayoutData((Object)new GridData(32));
            SingleEClassifierSelectionDialog.applyDialogFont((Control)l);
            return l;
        }

        public Action getAction() {
            return this.action;
        }
    }
}

