/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.impl.ObjectKeyImpl;
import org.eclipse.emf.henshin.statespace.util.ObjectKeyHelper;

public class ModelImpl
extends MinimalEObjectImpl.Container
implements Model {
    protected static final Resource RESOURCE_EDEFAULT = null;
    protected Resource resource = RESOURCE_EDEFAULT;
    protected static final EmfGraph EMF_GRAPH_EDEFAULT = null;
    protected EmfGraph emfGraph = EMF_GRAPH_EDEFAULT;
    protected EMap<EObject, Integer> objectKeysMap;
    protected static final int[] OBJECT_KEYS_EDEFAULT = null;
    protected static final int OBJECT_COUNT_EDEFAULT = 0;

    public ModelImpl(Resource resource) {
        this.resource = resource;
    }

    public ModelImpl(Resource resource, EmfGraph emfGraph) {
        this.resource = resource;
        this.emfGraph = emfGraph;
    }

    @Override
    public EMap<EObject, Integer> getObjectKeysMap() {
        if (this.objectKeysMap == null) {
            this.objectKeysMap = new ObjectKeyMap(this);
        }
        return this.objectKeysMap;
    }

    @Override
    public EmfGraph getEmfGraph() {
        if (this.emfGraph == null) {
            this.emfGraph = new EmfGraph();
            for (EObject root : this.resource.getContents()) {
                this.emfGraph.addRoot(root);
            }
        }
        return this.emfGraph;
    }

    @Override
    public Model getCopy(Match match) {
        ResourceImpl copiedResource = new ResourceImpl();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        copiedResource.getContents().addAll(copier.copyAll((Collection)this.resource.getContents()));
        copier.copyReferences();
        if (match != null) {
            this.updateMatch(match, copier);
        }
        EmfGraph copiedGraph = null;
        if (this.emfGraph != null) {
            copiedGraph = new EmfGraph(this.emfGraph, copier);
        }
        ModelImpl copy = new ModelImpl((Resource)copiedResource, copiedGraph);
        if (this.objectKeysMap != null) {
            TreeIterator iterator = this.resource.getAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                copy.getObjectKeysMap().put((Object)((EObject)copier.get((Object)object)), (Object)((Integer)this.objectKeysMap.get((Object)object)));
            }
        }
        return copy;
    }

    private void updateMatch(Match match, EcoreUtil.Copier copier) {
        for (Node node : match.getNodeMapping().keySet()) {
            EObject newImage = (EObject)copier.get(match.getNodeMapping().get(node));
            match.getNodeMapping().put(node, newImage);
        }
        for (Rule rule : match.getNestedMatches().keySet()) {
            for (Match nested : match.getNestedMatchesFor(rule)) {
                this.updateMatch(nested, copier);
            }
        }
    }

    @Override
    public boolean updateObjectKeys(EList<EClass> identityTypes) {
        this.getObjectKeysMap();
        boolean changed = false;
        int nextFreeId = this.getNextFreeId();
        TreeIterator iterator = this.resource.getAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            int currentId = ObjectKeyHelper.getObjectID((Integer)this.objectKeysMap.get((Object)object));
            if (currentId == 0 && identityTypes.contains((Object)object.eClass())) {
                int objectKey = ObjectKeyHelper.createObjectKey(object.eClass(), nextFreeId++, identityTypes);
                this.objectKeysMap.put((Object)object, (Object)objectKey);
                changed = true;
                continue;
            }
            if (currentId == 0 || identityTypes.contains((Object)object.eClass())) continue;
            this.objectKeysMap.remove((Object)object);
            changed = true;
        }
        return changed;
    }

    private int getNextFreeId() {
        this.getObjectKeysMap();
        int nextFreeId = 1;
        TreeIterator iterator = this.resource.getAllContents();
        while (iterator.hasNext()) {
            int id = ObjectKeyHelper.getObjectID((Integer)this.objectKeysMap.get(iterator.next()));
            if (id < nextFreeId) continue;
            nextFreeId = id + 1;
        }
        return nextFreeId;
    }

    @Override
    public void collectMissingRootObjects() {
        if (this.emfGraph != null) {
            for (EObject root : this.emfGraph.getRootObjects()) {
                if (this.resource.getContents().contains((Object)root)) continue;
                System.out.println("Warning: collected missing root object");
                this.resource.getContents().add((Object)root);
            }
        }
    }

    @Override
    public int[] getObjectKeys() {
        this.getObjectKeysMap();
        ArrayList<Integer> objectKeys = new ArrayList<Integer>(24);
        TreeIterator iterator = this.resource.getAllContents();
        while (iterator.hasNext()) {
            objectKeys.add((Integer)this.objectKeysMap.get(iterator.next()));
        }
        int[] result = new int[objectKeys.size()];
        int i = 0;
        while (i < objectKeys.size()) {
            result[i] = (Integer)objectKeys.get(i);
            ++i;
        }
        return result;
    }

    @Override
    public void setObjectKeys(int[] objectKeys) {
        this.getObjectKeysMap().clear();
        TreeIterator iterator = this.resource.getAllContents();
        int index = 0;
        while (iterator.hasNext() && index < objectKeys.length) {
            EObject object = (EObject)iterator.next();
            int key = objectKeys[index++];
            this.objectKeysMap.put((Object)object, (Object)key);
        }
    }

    @Override
    public int getObjectCount() {
        if (this.emfGraph == null) {
            this.getEmfGraph();
        }
        return this.emfGraph.geteObjects().size();
    }

    protected ModelImpl() {
    }

    protected EClass eStaticClass() {
        return StateSpacePackage.Literals.MODEL;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getObjectKeysMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getResource();
            }
            case 1: {
                return this.getEmfGraph();
            }
            case 2: {
                if (coreType) {
                    return this.getObjectKeysMap();
                }
                return this.getObjectKeysMap().map();
            }
            case 3: {
                return this.getObjectKeys();
            }
            case 4: {
                return this.getObjectCount();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                ((EStructuralFeature.Setting)this.getObjectKeysMap()).set(newValue);
                return;
            }
            case 3: {
                this.setObjectKeys((int[])newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getObjectKeysMap().clear();
                return;
            }
            case 3: {
                this.setObjectKeys(OBJECT_KEYS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return RESOURCE_EDEFAULT == null ? this.resource != null : !RESOURCE_EDEFAULT.equals(this.resource);
            }
            case 1: {
                return EMF_GRAPH_EDEFAULT == null ? this.emfGraph != null : !EMF_GRAPH_EDEFAULT.equals(this.emfGraph);
            }
            case 2: {
                return this.objectKeysMap != null && !this.objectKeysMap.isEmpty();
            }
            case 3: {
                return OBJECT_KEYS_EDEFAULT == null ? this.getObjectKeys() != null : !OBJECT_KEYS_EDEFAULT.equals(this.getObjectKeys());
            }
            case 4: {
                return this.getObjectCount() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (resource: ");
        result.append(this.resource);
        result.append(", emfGraph: ");
        result.append(this.emfGraph);
        result.append(')');
        return result.toString();
    }

    private static class ObjectKeyMap
    extends EcoreEMap<EObject, Integer> {
        private static final Integer ZERO = new Integer(0);
        private static final long serialVersionUID = 1L;

        public ObjectKeyMap(ModelImpl model) {
            super(StateSpacePackage.Literals.OBJECT_KEY, ObjectKeyImpl.class, (InternalEObject)model, 2);
        }

        public Integer get(Object object) {
            Integer key = (Integer)super.get(object);
            return key != null ? key : ZERO;
        }
    }
}

