/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TransformationOptions {
    public static final String INJECTIVE = "injective";
    public static final String DANGLING = "dangling";
    public static final String DETERMINISTIC = "deterministic";
    private Map<String, Object> options = new HashMap<String, Object>();

    public void setInjective(boolean injective) {
        this.setOption(INJECTIVE, injective);
    }

    public void setDeterministic(boolean deterministic) {
        this.setOption(DETERMINISTIC, deterministic);
    }

    public void setDangling(boolean dangling) {
        this.setOption(DANGLING, dangling);
    }

    public Object getOption(String key) {
        return this.options.get(key);
    }

    public void setOption(String key, Object value) {
        this.options.put(key, value);
    }

    public void unsetOption(String key) {
        this.options.remove(key);
    }

    public TransformationOptions copy() {
        TransformationOptions copy = new TransformationOptions();
        copy.options = new HashMap<String, Object>(this.options);
        return copy;
    }

    public String toString() {
        String result = "";
        ArrayList<String> setOptions = new ArrayList<String>(this.options.keySet());
        Collections.sort(setOptions);
        for (String option : setOptions) {
            result = String.valueOf(result) + option + ": " + this.options.get(option) + " ";
        }
        return result;
    }
}

