/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.conditions.attribute;

import java.util.Collection;
import java.util.HashSet;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class AttributeCondition {
    String conditionText;
    private Collection<String> remainingParameters;
    private ScriptEngine scriptEngine;

    public AttributeCondition(String condition, Collection<String> conditionParameters, ScriptEngine engine) {
        this.conditionText = condition;
        this.remainingParameters = new HashSet<String>(conditionParameters);
        this.scriptEngine = engine;
    }

    public boolean eval() {
        if (this.remainingParameters.isEmpty()) {
            try {
                return (Boolean)this.scriptEngine.eval(this.conditionText);
            }
            catch (ScriptException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Warning: Attribute condition did not return a boolean value");
            }
        }
        return true;
    }

    void addParameter(String parameterName) {
        this.remainingParameters.add(parameterName);
    }

    void removeParameter(String parameterName) {
        this.remainingParameters.remove(parameterName);
    }
}

