/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.diagram.edit.helpers.HenshinBaseEditHelper;
import org.eclipse.emf.henshin.model.TransformationSystem;

public class TransformationSystemEditHelper
extends HenshinBaseEditHelper {
    public static EClassifier[] findEClassifierByName(TransformationSystem ts, String name) {
        if (name == null) {
            return new EClassifier[0];
        }
        EClassifier result = null;
        String[] names = (name = name.trim()).split("\\.");
        if (names.length > 1) {
            for (EPackage p : ts.getImports()) {
                if (!p.getName().equals(names[0])) continue;
                result = TransformationSystemEditHelper.findClassifierByFQN(p, names, 1);
                break;
            }
            return new EClassifier[]{result};
        }
        List<EClassifier> eclassifierList = TransformationSystemEditHelper.collectAllEClassifier(ts);
        ArrayList<EClassifier> resultList = new ArrayList<EClassifier>();
        for (EClassifier ec : eclassifierList) {
            if (!ec.getName().equals(name)) continue;
            resultList.add(ec);
        }
        return resultList.toArray(new EClassifier[resultList.size()]);
    }

    private static EClassifier findClassifierByFQN(EPackage p, String[] fqn, int index) {
        EClassifier result = null;
        if (index < fqn.length - 1) {
            for (EPackage pp : p.getESubpackages()) {
                if (!pp.getName().equals(fqn[index])) continue;
                result = TransformationSystemEditHelper.findClassifierByFQN(pp, fqn, index + 1);
                break;
            }
        } else {
            result = p.getEClassifier(fqn[fqn.length - 1]);
        }
        return result;
    }

    public static List<EClassifier> collectAllEClassifier(TransformationSystem ts) {
        ArrayList<EClassifier> list = new ArrayList<EClassifier>();
        for (EPackage p : ts.getImports()) {
            TransformationSystemEditHelper.collectAllEClassifierHelper(list, p);
        }
        return list;
    }

    private static void collectAllEClassifierHelper(List<EClassifier> elements, EPackage p) {
        elements.addAll((Collection<EClassifier>)p.getEClassifiers());
        for (EPackage p2 : p.getESubpackages()) {
            TransformationSystemEditHelper.collectAllEClassifierHelper(elements, p2);
        }
    }
}

