/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinACUtil;
import org.eclipse.emf.henshin.model.util.HenshinMultiRuleUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class EdgeDeleteCommand
extends AbstractTransactionalCommand {
    private Edge edge;

    public EdgeDeleteCommand(TransactionalEditingDomain domain, Edge edge) {
        super(domain, "Delete Edge", null);
        this.edge = edge;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.edge.getGraph() == null || this.edge.getGraph().getContainerRule() == null) {
            return CommandResult.newErrorCommandResult((String)"Edge not contained in graph / rule");
        }
        Rule rule = this.edge.getGraph().getContainerRule();
        this.doRemove(this.edge);
        HenshinACUtil.removeTrivialACs((Rule)rule);
        HenshinMultiRuleUtil.removeTrivialMultiRules((Rule)rule);
        return CommandResult.newOKCommandResult();
    }

    private void doRemove(Edge edge) throws ExecutionException {
        View ruleView;
        if (edge == null) {
            return;
        }
        Node source = edge.getSource();
        Node target = edge.getTarget();
        EReference type = edge.getType();
        Rule rule = edge.getGraph().getContainerRule();
        rule.removeEdge(edge, true);
        if (type != null && (type.isContainment() || type.isContainer()) && (ruleView = RootObjectEditHelper.findRuleView(rule)) != null) {
            RootObjectEditHelper.updateRootContainment(ruleView, source);
            RootObjectEditHelper.updateRootContainment(ruleView, target);
        }
    }
}

