/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.presentation.HenshinIcons;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class EcoreSelectionDialogUtil {
    public static EPackage selectEcoreFilePackage(Shell shell, ResourceSet resourceSet) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new EcoreLabelProvider(), (ITreeContentProvider)new EcoreContentProvider(resourceSet));
        dialog.setTitle("Select EPackage");
        dialog.setMessage("Please select the EPackage to import:");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter((ViewerFilter)new EcoreViewFilter());
        dialog.setValidator((ISelectionStatusValidator)new EcoreSelectionValidator());
        dialog.setAllowMultiple(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0 && result[0] instanceof EPackage) {
            return (EPackage)result[0];
        }
        return null;
    }

    public static EPackage selectRegisteredPackage(Shell shell, ResourceSet resourceSet) {
        EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog dialog = new EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog(shell);
        dialog.setMultipleSelection(false);
        dialog.open();
        EPackage epackage = null;
        Object[] result = dialog.getResult();
        if (result != null) {
            List<Object> nsURIs = Arrays.asList(result);
            if (dialog.isDevelopmentTimeVersion()) {
                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                Map locationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
                if (result.length > 0) {
                    URI location = (URI)locationMap.get(result[0]);
                    Resource resource = resourceSet.getResource(location, true);
                    EcoreUtil.resolveAll((Resource)resource);
                }
                block0: for (Resource resource : resourceSet.getResources()) {
                    for (EPackage current : EcoreSelectionDialogUtil.getAllPackages(resource)) {
                        if (!nsURIs.contains(current.getNsURI())) continue;
                        epackage = current;
                        continue block0;
                    }
                }
            } else if (result.length > 0) {
                String uri = result[0].toString();
                return EPackage.Registry.INSTANCE.getEPackage(uri);
            }
        }
        return epackage;
    }

    protected static Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> iterator = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                if (eObject instanceof EPackage) {
                    return ((EPackage)eObject).getESubpackages().iterator();
                }
                return Collections.emptyList().iterator();
            }
        };
        while (iterator.hasNext()) {
            Object current = iterator.next();
            if (!(current instanceof EPackage)) continue;
            result.add((EPackage)current);
        }
        return result;
    }

    static class EcoreContentProvider
    extends BaseWorkbenchContentProvider {
        private ResourceSet resourceSet;

        public EcoreContentProvider(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        public Object[] getChildren(Object element) {
            IResource res;
            IAdaptable adapter;
            Object adaptedResource;
            if (element instanceof IAdaptable && (adaptedResource = (adapter = (IAdaptable)element).getAdapter(IResource.class)) != null && "ecore".equals((res = (IResource)adaptedResource).getFileExtension())) {
                return this.resourceSet.getResource(URI.createPlatformResourceURI((String)res.getFullPath().toString(), (boolean)true), true).getContents().toArray();
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                return eObject.eContents().toArray();
            }
            return super.getChildren(element);
        }
    }

    static class EcoreLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        EcoreLabelProvider() {
        }

        public Image getImage(Object element) {
            IAdaptable adaptable;
            Object adapter;
            if (element instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                IWorkbenchAdapter res = (IWorkbenchAdapter)adapter;
                return res.getImageDescriptor(element).createImage();
            }
            if (element instanceof EPackage) {
                return HenshinIcons.EPACKAGE;
            }
            return null;
        }

        public String getText(Object element) {
            IAdaptable adaptable;
            Object adapter;
            if (element instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                IWorkbenchAdapter res = (IWorkbenchAdapter)adapter;
                return res.getLabel(element);
            }
            if (element instanceof ENamedElement) {
                ENamedElement namedElem = (ENamedElement)element;
                return namedElem.getName();
            }
            return element.toString();
        }
    }

    static class EcoreSelectionValidator
    implements ISelectionStatusValidator {
        EcoreSelectionValidator() {
        }

        public IStatus validate(Object[] selection) {
            Object obj;
            if (selection.length > 0 && (obj = selection[0]) instanceof EPackage) {
                return new Status(0, "org.eclipse.emf.henshin.editor", "EPackage selected");
            }
            return new Status(4, "org.eclipse.emf.henshin.editor", "No valid EPackage selected");
        }
    }

    static class EcoreViewFilter
    extends ViewerFilter {
        EcoreViewFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IResource res;
            IAdaptable adapter;
            Object adaptedResource;
            if (element instanceof IAdaptable && (adaptedResource = (adapter = (IAdaptable)element).getAdapter(IResource.class)) != null && ("ecore".equals((res = (IResource)adaptedResource).getFileExtension()) || 1 != res.getType())) {
                return true;
            }
            return element instanceof EObject;
        }
    }
}

