/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;

/**
 * @author koehnlein - Initial contribution and API
 */
public class CompositeIndexAdapter extends EContentAdapter {

	private List<IndexAdapter> indexAdapters;

	private boolean isActive;

	public CompositeIndexAdapter() {
		indexAdapters = new ArrayList<IndexAdapter>();
		isActive = true;
	}

	public void setActive(boolean isActive) {
		this.isActive = isActive;
	}

	@Override
	public void notifyChanged(Notification notification) {
		super.notifyChanged(notification);
		if (isActive) {
			for (IndexAdapter cachedScope : indexAdapters) {
				cachedScope.notifyChanged(notification);
			}
		}
	}
	
	public boolean addIndexAdapter(IndexAdapter adapter) {
		IndexAdapter existingCache = findIndexAdapter(adapter.getClass());
		if (existingCache != null) {
			return false;
		}
		indexAdapters.add(adapter);
		return true;
	}

	public boolean removeIndexAdapter(IndexAdapter adapter) {
		return indexAdapters.remove(adapter);
	}

	@SuppressWarnings("unchecked")
	public <T extends IndexAdapter> T findIndexAdapter(Class<T> adapterClass) {
		for (IndexAdapter registeredCaches : indexAdapters) {
			if (registeredCaches.getClass().equals(adapterClass))
				return (T) registeredCaches;
		}
		return null;
	}
	
	public void clear() {
		for (IndexAdapter indexCache : indexAdapters) {
			indexCache.clear();
		}
	}
	
}