/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfindex.Logger;
import org.eclipse.emf.emfindex.query.spi.QueryExecutorStrategy;
import org.eclipse.emf.emfindex.query.spi.QueryExecutorWithStrategies;
import org.eclipse.emf.emfindex.util.StringUtils;

@Singleton
public class QueryExecutorStrategyRegistryReader {
    public static final String EXTENSION_POINT_ID = "org.eclipse.emf.emfindex.queryExecutorStrategy";
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final String PRIORITY_ATTRIBUTE_NAME = "priority";

    @Inject
    public QueryExecutorStrategyRegistryReader(QueryExecutorWithStrategies queryExecutorWithStrategies, Logger logger) {
        IConfigurationElement[] configurationElementsFor;
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                QueryExecutorStrategy strategy = (QueryExecutorStrategy)configurationElement.createExecutableExtension(CLASS_ATTRIBUTE_NAME);
                int priority = 0;
                String priorityAttribute = configurationElement.getAttribute(PRIORITY_ATTRIBUTE_NAME);
                try {
                    priority = Integer.parseInt(priorityAttribute);
                }
                catch (NumberFormatException numberFormatException) {
                    String className = configurationElement.getAttribute(CLASS_ATTRIBUTE_NAME);
                    logger.logError(StringUtils.concat("Invalid priority ", priorityAttribute, " for class ", className, ". Using default priority."));
                }
                queryExecutorWithStrategies.addQueryExecutorStrategy(strategy, priority);
            }
            catch (CoreException e) {
                logger.logError(e.getMessage(), e);
            }
            ++n2;
        }
    }
}

