/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.eef.EEFReferenceDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFReferenceController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.ActionButton;
import org.eclipse.eef.ide.ui.internal.widgets.EEFReferenceHyperlinkListener;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class EEFReferenceLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int DEFAULT_HEIGHT = 34;
    private EEFReferenceDescription description;
    private Hyperlink hyperlink;
    private Label text;
    private List<ActionButton> actionButtons = new ArrayList<ActionButton>();
    private IEEFReferenceController controller;
    private IHyperlinkListener onClickListener;
    private EEFWidgetFactory widgetFactory;
    private Color defaultBackgroundColor;

    public EEFReferenceLifecycleManager(EEFReferenceDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        this.defaultBackgroundColor = parent.getBackground();
        Composite reference = this.widgetFactory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        reference.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        reference.setLayoutData((Object)gridData);
        this.createSingleValuedReferenceWidget(reference);
        this.createWidgetActionButtons(reference);
        this.widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createReferenceController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    private void createWidgetActionButtons(Composite parent) {
        Composite buttons = this.widgetFactory.createFlatFormComposite(parent);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        buttons.setLayoutData((Object)gridData);
        buttons.setLayout((Layout)new GridLayout(this.description.getActions().size(), true));
        for (EEFWidgetAction action : this.description.getActions()) {
            ActionButton actionButton = new ActionButton(action, buttons, this.widgetFactory, this.interpreter, this.variableManager);
            this.actionButtons.add(actionButton);
        }
    }

    private void createSingleValuedReferenceWidget(Composite parent) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        int clientWidth = parent.getClientArea().width;
        if (!Util.isBlank((String)this.description.getOnClickExpression())) {
            this.hyperlink = this.widgetFactory.createHyperlink(parent, "", 0);
            this.hyperlink.setLayoutData((Object)gridData);
            this.hyperlink.setSize(clientWidth, 34);
        } else {
            this.text = this.widgetFactory.createLabel(parent, "", 0);
            this.text.setLayoutData((Object)gridData);
            this.text.setSize(clientWidth, 34);
        }
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.hyperlink != null) {
            this.onClickListener = new EEFReferenceHyperlinkListener(this.controller);
            this.hyperlink.addHyperlinkListener(this.onClickListener);
        }
        this.controller.onNewValue((IConsumer)new IConsumer<Object>(){

            public void apply(Object value) {
                if (value == null) {
                    return;
                }
                EEFReferenceLifecycleManager.this.setSingleValuedReference(value);
            }
        });
        for (final ActionButton actionButton : this.actionButtons) {
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<Object> selections = new ArrayList<Object>();
                    if (EEFReferenceLifecycleManager.this.hyperlink != null) {
                        selections.add(EEFReferenceLifecycleManager.this.hyperlink.getData());
                    } else {
                        selections.add(EEFReferenceLifecycleManager.this.text.getData());
                    }
                    EEFReferenceLifecycleManager.this.controller.action(actionButton.getAction(), selections);
                }
            };
            actionButton.addSelectionListener(selectionListener);
        }
    }

    private void setSingleValuedReference(Object value) {
        String expression = this.description.getDisplayExpression();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(this.variableManager.getVariables());
        variables.put("value", value);
        String display = (String)EvalFactory.of((IInterpreter)this.interpreter, variables).logIfInvalidType(String.class).evaluate(expression);
        if (!Util.isBlank((String)display)) {
            if (!(this.hyperlink == null || this.hyperlink.isDisposed() || this.hyperlink.getText() != null && this.hyperlink.getText().equals(value))) {
                this.hyperlink.setText(display);
                this.hyperlink.setData(value);
                if (!this.hyperlink.isEnabled() && this.isEnabled()) {
                    this.hyperlink.setEnabled(true);
                }
            } else if (!(this.text == null || this.text.isDisposed() || this.text.getText() != null && this.text.getText().equals(value))) {
                this.text.setText(display);
                this.text.setData(value);
                if (!this.text.isEnabled() && this.isEnabled()) {
                    this.text.setEnabled(true);
                }
            }
        }
    }

    @Override
    protected Control getValidationControl() {
        if (this.hyperlink != null) {
            return this.hyperlink;
        }
        return this.text;
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.hyperlink != null && !this.hyperlink.isDisposed()) {
            this.hyperlink.removeHyperlinkListener(this.onClickListener);
        }
        for (ActionButton actionButton : this.actionButtons) {
            actionButton.removeSelectionListener();
        }
        this.controller.removeNewValueConsumer();
        this.actionButtons.clear();
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected int getLabelVerticalAlignment() {
        if (!this.description.isMultiple()) {
            return 4;
        }
        return super.getLabelVerticalAlignment();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.text != null) {
            this.text.setEnabled(this.isEnabled());
            this.text.setBackground(this.getBackgroundColor());
        } else if (this.hyperlink != null) {
            this.hyperlink.setEnabled(this.isEnabled());
            this.hyperlink.setBackground(this.getBackgroundColor());
        }
        for (ActionButton actionButton : this.actionButtons) {
            actionButton.setEnabled(this.isEnabled());
        }
    }

    private Color getBackgroundColor() {
        Color color = this.defaultBackgroundColor;
        if (!this.isEnabled()) {
            color = this.widgetFactory.getColors().getInactiveBackground();
        }
        return color;
    }
}

