/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ui.generators.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.codegen.ui.generators.common.GenerateAll;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateEEFAction
extends Action
implements IObjectActionDelegate {
    protected List<IFile> selectedFiles = new ArrayList<IFile>();
    protected List<EEFGenModel> eefGenModels;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.selectedFiles != null) {
            Job generationJob = new Job("EEF architecture generation"){

                protected IStatus run(IProgressMonitor monitor) {
                    block12: {
                        try {
                            try {
                                List<EEFGenModel> eefgenmodels = AbstractGenerateEEFAction.this.initEEFGenModel();
                                if (eefgenmodels == null || monitor.isCanceled()) break block12;
                                monitor.beginTask("Generating EEF Architecture", -1);
                                for (EEFGenModel eefGenModel : eefgenmodels) {
                                    IContainer target = AbstractGenerateEEFAction.this.getGenContainer(eefGenModel);
                                    if (target != null) {
                                        monitor.subTask("Generating " + eefGenModel.eResource().getURI().lastSegment() + " Architecture");
                                        int count = 2;
                                        if (eefGenModel.getEditionContexts() != null) {
                                            count += eefGenModel.getEditionContexts().size() * 11;
                                        }
                                        if (eefGenModel.getViewsRepositories() != null) {
                                            count += eefGenModel.getViewsRepositories().size() * 5;
                                        }
                                        GenerateAll generator = new GenerateAll(target, eefGenModel);
                                        generator.doGenerate(monitor);
                                        for (IContainer nextContainer : generator.getGenerationTargets()) {
                                            nextContainer.refreshLocal(2, monitor);
                                        }
                                        monitor.worked(count);
                                    }
                                    if (!monitor.isCanceled()) continue;
                                    break;
                                }
                            }
                            catch (IOException e) {
                                EEFCodegenPlugin.getDefault().logError(e);
                                IStatus iStatus = Status.CANCEL_STATUS;
                                monitor.done();
                                AbstractGenerateEEFAction.this.selectedFiles.clear();
                                return iStatus;
                            }
                            catch (CoreException e) {
                                EEFCodegenPlugin.getDefault().logError((Exception)((Object)e));
                                IStatus iStatus = Status.CANCEL_STATUS;
                                monitor.done();
                                AbstractGenerateEEFAction.this.selectedFiles.clear();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                            AbstractGenerateEEFAction.this.selectedFiles.clear();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            generationJob.setUser(true);
            generationJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            generationJob.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedFiles.clear();
        if (selection instanceof StructuredSelection) {
            StructuredSelection sSelection = (StructuredSelection)selection;
            for (Object selectedElement : sSelection.toList()) {
                if (!(selectedElement instanceof IFile)) continue;
                this.selectedFiles.add((IFile)selectedElement);
            }
        }
    }

    protected abstract List<EEFGenModel> initEEFGenModel() throws IOException;

    public IContainer getGenContainer(EEFGenModel eefGenModel) throws IOException {
        if (eefGenModel != null && eefGenModel.getGenDirectory() != null) {
            IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(eefGenModel.getGenDirectory()));
            return target;
        }
        return null;
    }
}

