/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.viewers;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;
import org.eclipse.swt.widgets.Display;

public abstract class PropertiesEditionMessageManager {
    public void processMessage(IPropertiesEditionEvent event) {
        if (event instanceof PropertiesValidationEditionEvent) {
            final Diagnostic diag = ((PropertiesValidationEditionEvent)event).getDiagnostic();
            if (diag != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        String message = PropertiesEditionMessageManager.this.computeMessage(diag);
                        if (diag.getSeverity() == 4) {
                            PropertiesEditionMessageManager.this.updateError(message);
                        } else if (diag.getSeverity() == 2) {
                            PropertiesEditionMessageManager.this.updateWarning(message);
                        } else {
                            PropertiesEditionMessageManager.this.updateStatus(message);
                        }
                    }
                });
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PropertiesEditionMessageManager.this.updateStatus(null);
                    }
                });
            }
        }
    }

    protected abstract void updateStatus(String var1);

    protected void updateError(String message) {
        this.updateStatus(message);
    }

    protected void updateWarning(String message) {
        this.updateStatus(message);
    }

    private String computeMessage(Diagnostic diag) {
        if (diag.getSeverity() == 0) {
            return "";
        }
        for (Diagnostic child : diag.getChildren()) {
            if (child.getSeverity() == 0) continue;
            if (child.getChildren().isEmpty()) {
                return child.getMessage();
            }
            return this.computeMessage(child);
        }
        return diag.getMessage();
    }
}

