/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.validation.util.FilteredCollection;

public class FilteredCollectionTest
extends TestCase {
    private final Filter filter = new Filter();
    private final Collection<Integer> original = Arrays.asList(0, 1, 2, 3, 4, 5);
    private final Collection<Integer> expectedFilteredResult = Arrays.asList(0, 2, 4);
    private final FilteredCollection<Integer> filteredCollection = new FilteredCollection(this.original, (FilteredCollection.Filter)this.filter);

    public static Test suite() {
        return new TestSuite(FilteredCollectionTest.class);
    }

    public void test_getFilter() {
        FilteredCollectionTest.assertSame((Object)this.filter, (Object)this.filteredCollection.getFilter());
    }

    public void test_size() {
        FilteredCollectionTest.assertEquals((int)this.expectedFilteredResult.size(), (int)this.filteredCollection.size());
    }

    public void test_iterator() {
        FilteredCollectionTest.assertEquals(this.expectedFilteredResult, new ArrayList<Integer>((Collection<Integer>)this.filteredCollection));
        int i = 0;
        for (Integer next : this.filteredCollection) {
            FilteredCollectionTest.assertEquals((int)i, (int)next);
            i += 2;
        }
    }

    private class Filter
    implements FilteredCollection.Filter<Integer> {
        private Filter() {
        }

        public boolean accept(Integer element) {
            return element % 2 == 0;
        }
    }
}

