/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import ordersystem.OrderSystemFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class ConstraintStatusTest
extends TestCase {
    private static final String TEST_NAME = "Testing";
    private static final String TEST_ID = "test.id";
    private static final String TEST_PLUGIN = "test.plugin";
    private static final String TEST_MESSAGE = "Error happened";
    private static final int TEST_CODE = 1000;
    private static final ConstraintSeverity TEST_SEVERITY = ConstraintSeverity.WARNING;
    private static final EObject TEST_TARGET = OrderSystemFactory.eINSTANCE.createWarehouse();
    private static final Set<EObject> TEST_RESULTLOCUS = Collections.singleton(TEST_TARGET);
    private static FixtureConstraint fixtureConstraint;
    private static ConstraintStatus successFixture;
    private static ConstraintStatus failedFixture;

    private static FixtureConstraint getFixtureConstraint() {
        if (fixtureConstraint == null) {
            fixtureConstraint = new FixtureConstraint(TEST_NAME, TEST_ID, TEST_PLUGIN, TEST_SEVERITY, 1000);
        }
        return fixtureConstraint;
    }

    private static ConstraintStatus getSuccessFixture() {
        if (successFixture == null) {
            successFixture = new ConstraintStatus((IModelConstraint)ConstraintStatusTest.getFixtureConstraint(), TEST_TARGET);
        }
        return successFixture;
    }

    private static ConstraintStatus getFailedFixture() {
        if (failedFixture == null) {
            failedFixture = new ConstraintStatus((IModelConstraint)ConstraintStatusTest.getFixtureConstraint(), TEST_TARGET, TEST_MESSAGE, TEST_RESULTLOCUS);
        }
        return failedFixture;
    }

    public void test_getConstraint() {
        ConstraintStatusTest.assertSame((Object)ConstraintStatusTest.getFixtureConstraint(), (Object)ConstraintStatusTest.getSuccessFixture().getConstraint());
        ConstraintStatusTest.assertSame((Object)ConstraintStatusTest.getFixtureConstraint(), (Object)ConstraintStatusTest.getFailedFixture().getConstraint());
    }

    public void test_getTarget() {
        ConstraintStatusTest.assertEquals((Object)TEST_TARGET, (Object)ConstraintStatusTest.getSuccessFixture().getTarget());
        ConstraintStatusTest.assertEquals((Object)TEST_TARGET, (Object)ConstraintStatusTest.getFailedFixture().getTarget());
    }

    public void test_getResultLocus() {
        ConstraintStatusTest.assertTrue((boolean)ConstraintStatusTest.getSuccessFixture().getResultLocus().isEmpty());
        ConstraintStatusTest.assertTrue((boolean)ConstraintStatusTest.getFailedFixture().getResultLocus().containsAll(TEST_RESULTLOCUS));
    }

    public void test_getChildren() {
        ConstraintStatusTest.assertTrue((ConstraintStatusTest.getSuccessFixture().getChildren().length == 0 ? 1 : 0) != 0);
        ConstraintStatusTest.assertTrue((ConstraintStatusTest.getFailedFixture().getChildren().length == 0 ? 1 : 0) != 0);
    }

    public void test_getCode() {
        ConstraintStatusTest.assertEquals((int)0, (int)ConstraintStatusTest.getSuccessFixture().getCode());
        ConstraintStatusTest.assertEquals((int)1000, (int)ConstraintStatusTest.getFailedFixture().getCode());
    }

    public void test_getMessage() {
        ConstraintStatusTest.assertEquals((String)EMFModelValidationStatusCodes.CONSTRAINT_SUCCESS_MSG, (String)ConstraintStatusTest.getSuccessFixture().getMessage());
        ConstraintStatusTest.assertEquals((String)TEST_MESSAGE, (String)ConstraintStatusTest.getFailedFixture().getMessage());
    }

    public void test_getPlugin() {
        ConstraintStatusTest.assertEquals((String)TEST_PLUGIN, (String)ConstraintStatusTest.getSuccessFixture().getPlugin());
        ConstraintStatusTest.assertEquals((String)TEST_PLUGIN, (String)ConstraintStatusTest.getFailedFixture().getPlugin());
    }

    public void test_getSeverity() {
        ConstraintStatusTest.assertEquals((int)0, (int)ConstraintStatusTest.getSuccessFixture().getSeverity());
        ConstraintStatusTest.assertEquals((int)TEST_SEVERITY.toIStatusSeverity(), (int)ConstraintStatusTest.getFailedFixture().getSeverity());
    }

    public void test_isMultiStatus() {
        ConstraintStatusTest.assertFalse((boolean)ConstraintStatusTest.getSuccessFixture().isMultiStatus());
        ConstraintStatusTest.assertFalse((boolean)ConstraintStatusTest.getFailedFixture().isMultiStatus());
    }

    private static class FixtureConstraint
    implements IModelConstraint {
        private final String name;
        private final String id;
        private final String pluginId;
        private final ConstraintSeverity severity;
        private final int code;

        FixtureConstraint(String name, String id, String pluginId, ConstraintSeverity severity, int code) {
            this.name = name;
            this.id = id;
            this.pluginId = pluginId;
            this.severity = severity;
            this.code = code;
        }

        public IConstraintDescriptor getDescriptor() {
            return new IConstraintDescriptor(){

                public String getName() {
                    return name;
                }

                public String getId() {
                    return id;
                }

                public String getPluginId() {
                    return pluginId;
                }

                public ConstraintSeverity getSeverity() {
                    return severity;
                }

                public int getStatusCode() {
                    return code;
                }

                public String getDescription() {
                    return null;
                }

                public String getBody() {
                    return null;
                }

                public boolean isError() {
                    return false;
                }

                public boolean isEnabled() {
                    return true;
                }

                public void setEnabled(boolean enabled) {
                }

                public Throwable getException() {
                    return null;
                }

                public EvaluationMode<?> getEvaluationMode() {
                    return null;
                }

                public boolean targetsTypeOf(EObject eObject) {
                    return false;
                }

                public boolean targetsEvent(Notification notification) {
                    return false;
                }

                public boolean isBatch() {
                    return false;
                }

                public boolean isLive() {
                    return false;
                }

                public void setError(Throwable exception) {
                }

                public Set<Category> getCategories() {
                    return Collections.emptySet();
                }

                public void addCategory(Category category) {
                }

                public void removeCategory(Category category) {
                }

                public String getMessagePattern() {
                    return ConstraintStatusTest.TEST_MESSAGE;
                }
            };
        }

        public IStatus validate(IValidationContext ctx) {
            return null;
        }
    }
}

