/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class RegressionTest {
    PrintStream output;
    String oldFilename;
    String newFilename;
    String outFilename;
    public static final String NOTHING_CHANGED_MSG = "All tests unchanged.";

    public RegressionTest(String oldFilename, String newFilename, String outFilename) {
        this.oldFilename = oldFilename;
        this.newFilename = newFilename;
        this.outFilename = outFilename;
    }

    public static void main(String[] argv) {
        if (argv.length < 3) {
            System.err.println("Error: too few arguments");
            System.err.println("Usage: (progname) oldfile newfile outfile");
        } else {
            RegressionTest rt = new RegressionTest(argv[0], argv[1], argv[2]);
            rt.testRegressions();
        }
    }

    public void testRegressions() {
        String oldPass = "";
        String newPass = "";
        try {
            oldPass = RegressionTest.readFile(this.oldFilename);
            newPass = RegressionTest.readFile(this.newFilename);
        }
        catch (Exception e) {
            System.err.println("Error opening input file");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        try {
            this.output = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.outFilename))));
        }
        catch (Exception e) {
            System.err.println("Error opening output file");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        StringTokenizer oldst = new StringTokenizer(oldPass);
        StringTokenizer newst = new StringTokenizer(newPass);
        String[] oldTest = RegressionTest.nextTest(oldst);
        String[] newTest = RegressionTest.nextTest(newst);
        boolean nothingChanged = true;
        while (oldTest != null && newTest != null) {
            int compareName = oldTest[0].compareTo(newTest[0]);
            if (compareName == 0) {
                int compareStatus = oldTest[1].compareTo(newTest[1]);
                if (compareStatus != 0) {
                    nothingChanged = false;
                    this.output.println(RegressionTest.testChanged(newTest));
                }
                oldTest = RegressionTest.nextTest(oldst);
                newTest = RegressionTest.nextTest(newst);
                continue;
            }
            if (compareName < 0) {
                this.output.println(RegressionTest.testNotRun(oldTest));
                oldTest = RegressionTest.nextTest(oldst);
                nothingChanged = false;
                continue;
            }
            this.output.println(RegressionTest.testAdded(newTest));
            newTest = RegressionTest.nextTest(newst);
            nothingChanged = false;
        }
        while (oldTest != null) {
            this.output.println(RegressionTest.testNotRun(oldTest));
            oldTest = RegressionTest.nextTest(oldst);
            nothingChanged = false;
        }
        while (newTest != null) {
            this.output.println(RegressionTest.testAdded(newTest));
            newTest = RegressionTest.nextTest(newst);
            nothingChanged = false;
        }
        if (nothingChanged) {
            this.output.println(NOTHING_CHANGED_MSG);
        }
        this.output.close();
    }

    static String testNotRun(String[] test) {
        return "Not run: " + test[0];
    }

    static String testChanged(String[] test) {
        return "Changed: " + test[0] + ", " + test[1];
    }

    static String testAdded(String[] test) {
        return "New test: " + test[0] + ", Status: " + test[1];
    }

    static String readFile(String s) throws IOException {
        byte[] buf = new byte[8192];
        ByteArrayOutputStream aStream = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream r = new FileInputStream(s);){
            int n;
            while ((n = r.read(buf)) != -1) {
                aStream.write(buf, 0, n);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return aStream.toString();
    }

    static String[] nextTest(StringTokenizer st) {
        String[] test = new String[2];
        if (!st.hasMoreTokens()) {
            return null;
        }
        test[0] = st.nextToken();
        if (!st.hasMoreTokens()) {
            return null;
        }
        test[1] = st.nextToken();
        return test;
    }
}

