/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RWLockManager<K, V>
extends Lifecycle {
    public static final int WAIT = 0;
    public static final int NO_WAIT = 1;
    private LockStrategy<K, V> writeLockStrategy = new LockStrategy<K, V>(){

        @Override
        public boolean canObtainLock(LockEntry<K, V> entry, V context) {
            return entry.canObtainWriteLock(context);
        }

        @Override
        public LockEntry<K, V> lock(LockEntry<K, V> entry, V context) {
            return entry.writeLock(context);
        }

        @Override
        public LockEntry<K, V> unlock(LockEntry<K, V> entry, V context) {
            return entry.writeUnlock(context);
        }

        @Override
        public boolean isLocked(LockEntry<K, V> entry, V context) {
            return entry.isWriteLock(context);
        }

        @Override
        public boolean isLockedByOthers(LockEntry<K, V> entry, V context) {
            return entry.isWriteLockByOthers(context);
        }
    };
    private LockStrategy<K, V> readLockStrategy = new LockStrategy<K, V>(){

        @Override
        public boolean canObtainLock(LockEntry<K, V> entry, V context) {
            return entry.canObtainReadLock(context);
        }

        @Override
        public LockEntry<K, V> lock(LockEntry<K, V> entry, V context) {
            return entry.readLock(context);
        }

        @Override
        public LockEntry<K, V> unlock(LockEntry<K, V> entry, V context) {
            return entry.readUnlock(context);
        }

        @Override
        public boolean isLocked(LockEntry<K, V> entry, V context) {
            return entry.isReadLock(context);
        }

        @Override
        public boolean isLockedByOthers(LockEntry<K, V> entry, V context) {
            return entry.isReadLockByOthers(context);
        }
    };
    private Map<K, LockEntry<K, V>> lockEntries = new HashMap<K, LockEntry<K, V>>();
    private Object lockChanged = new Object();

    public void lock(LockType type, V context, Collection<? extends K> objectsToLock, long timeout) throws InterruptedException {
        this.lock(this.getLockingStrategy(type), context, objectsToLock, timeout);
    }

    public void lock(LockType type, V context, K objectToLock, long timeout) throws InterruptedException {
        this.lock(type, context, (K)Collections.singletonList(objectToLock), timeout);
    }

    public void unlock(LockType type, V context, Collection<? extends K> objectsToLock) {
        this.unlock(this.getLockingStrategy(type), context, objectsToLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(V context) {
        Object object = this.lockChanged;
        synchronized (object) {
            ArrayList<LockEntry<K, V>> lockEntrysToRemove = new ArrayList<LockEntry<K, V>>();
            ArrayList<LockEntry<K, V>> lockEntrysToAdd = new ArrayList<LockEntry<K, V>>();
            for (Map.Entry<K, LockEntry<K, V>> entry : this.lockEntries.entrySet()) {
                LockEntry<K, V> newEntry = entry.getValue().clearLock(context);
                if (newEntry == null) {
                    lockEntrysToRemove.add(entry.getValue());
                    continue;
                }
                if (newEntry == entry) continue;
                lockEntrysToAdd.add(newEntry);
            }
            for (LockEntry lockEntry : lockEntrysToRemove) {
                this.lockEntries.remove(lockEntry.getKey());
            }
            for (LockEntry lockEntry : lockEntrysToAdd) {
                this.lockEntries.put(lockEntry.getKey(), lockEntry);
            }
            this.lockChanged.notifyAll();
        }
    }

    public boolean hasLock(LockType type, V context, K objectToLock) {
        return this.hasLock(this.getLockingStrategy(type), context, objectToLock);
    }

    public boolean hasLockByOthers(LockType type, V context, K objectToLock) {
        LockStrategy<K, V> lockingStrategy = this.getLockingStrategy(type);
        LockEntry<K, V> entry = this.getLockEntry(objectToLock);
        return entry != null && lockingStrategy.isLockedByOthers(entry, context);
    }

    private LockStrategy<K, V> getLockingStrategy(LockType type) {
        if (type == LockType.READ) {
            return this.readLockStrategy;
        }
        if (type == LockType.WRITE) {
            return this.writeLockStrategy;
        }
        throw new IllegalArgumentException(type.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(LockStrategy<K, V> lockingStrategy, V context, Collection<? extends K> objectsToLock) {
        Object object = this.lockChanged;
        synchronized (object) {
            ArrayList<LockEntry<K, V>> lockEntrysToRemove = new ArrayList<LockEntry<K, V>>();
            ArrayList<LockEntry<K, V>> lockEntrysToAdd = new ArrayList<LockEntry<K, V>>();
            for (K k : objectsToLock) {
                LockEntry<K, V> entry = this.lockEntries.get(k);
                if (entry == null) {
                    throw new IllegalMonitorStateException();
                }
                LockEntry<K, V> newEntry = lockingStrategy.unlock(entry, context);
                if (newEntry == null) {
                    lockEntrysToRemove.add(entry);
                    continue;
                }
                if (newEntry == entry) continue;
                lockEntrysToAdd.add(newEntry);
            }
            for (LockEntry lockEntry : lockEntrysToRemove) {
                this.lockEntries.remove(lockEntry.getKey());
            }
            for (LockEntry lockEntry : lockEntrysToAdd) {
                this.lockEntries.put(lockEntry.getKey(), lockEntry);
            }
            this.lockChanged.notifyAll();
        }
    }

    private boolean hasLock(LockStrategy<K, V> lockingStrategy, V context, K objectToLock) {
        LockEntry<K, V> entry = this.getLockEntry(objectToLock);
        return entry != null && lockingStrategy.isLocked(entry, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(LockStrategy<K, V> lockStrategy, V context, Collection<? extends K> objectsToLocks, long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (true) {
            Object object = this.lockChanged;
            synchronized (object) {
                K conflict = this.obtainLock(lockStrategy, context, objectsToLocks);
                if (conflict == null) {
                    this.lockChanged.notifyAll();
                    return;
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (timeout != 0L && elapsedTime > timeout) {
                    throw new TimeoutRuntimeException("Conflict with " + conflict);
                }
                if (timeout == 0L) {
                    this.lockChanged.wait();
                } else {
                    this.lockChanged.wait(Math.max(1L, timeout - elapsedTime));
                }
            }
        }
    }

    private K obtainLock(LockStrategy<K, V> lockingStrategy, V context, Collection<? extends K> objectsToLock) {
        ArrayList<LockEntry<K, V>> lockEntrys = new ArrayList<LockEntry<K, V>>();
        for (K k : objectsToLock) {
            LockEntry<K, V> entry = this.lockEntries.get(k);
            if (entry == null) {
                entry = new NoLockEntry(k);
            }
            if (lockingStrategy.canObtainLock(entry, context)) {
                lockEntrys.add(entry);
                continue;
            }
            return k;
        }
        for (LockEntry lockEntry : lockEntrys) {
            this.lockEntries.put(lockEntry.getKey(), lockingStrategy.lock(lockEntry, context));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockEntry<K, V> getLockEntry(K objectToLock) {
        Object object = this.lockChanged;
        synchronized (object) {
            return this.lockEntries.get(objectToLock);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LockEntry<K, V> {
        public K getKey();

        public boolean isReadLock(V var1);

        public boolean isWriteLock(V var1);

        public boolean isReadLockByOthers(V var1);

        public boolean isWriteLockByOthers(V var1);

        public boolean canObtainReadLock(V var1);

        public boolean canObtainWriteLock(V var1);

        public LockEntry<K, V> readLock(V var1);

        public LockEntry<K, V> writeLock(V var1);

        public LockEntry<K, V> readUnlock(V var1);

        public LockEntry<K, V> writeUnlock(V var1);

        public LockEntry<K, V> clearLock(V var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LockStrategy<K, V> {
        public boolean isLocked(LockEntry<K, V> var1, V var2);

        public boolean canObtainLock(LockEntry<K, V> var1, V var2);

        public LockEntry<K, V> lock(LockEntry<K, V> var1, V var2);

        public LockEntry<K, V> unlock(LockEntry<K, V> var1, V var2);

        public boolean isLockedByOthers(LockEntry<K, V> var1, V var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockType {
        WRITE,
        READ;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NoLockEntry<K, V>
    implements LockEntry<K, V> {
        private K objectToLock;

        public NoLockEntry(K objectToLock) {
            this.objectToLock = objectToLock;
        }

        @Override
        public boolean canObtainWriteLock(V context) {
            return true;
        }

        @Override
        public boolean canObtainReadLock(V context) {
            return true;
        }

        @Override
        public LockEntry<K, V> readLock(V context) {
            return new ReadLockEntry<K, V>(this.objectToLock, context);
        }

        @Override
        public LockEntry<K, V> writeLock(V context) {
            return new WriteLockEntry<K, V>(this.objectToLock, context, null);
        }

        @Override
        public K getKey() {
            return this.objectToLock;
        }

        @Override
        public LockEntry<K, V> readUnlock(V context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LockEntry<K, V> writeUnlock(V context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadLock(V context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWriteLock(V context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LockEntry<K, V> clearLock(V context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadLockByOthers(V context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWriteLockByOthers(V context) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadLockEntry<K, V>
    implements LockEntry<K, V> {
        private K id;
        private Set<V> contexts = new HashBag<V>();

        public ReadLockEntry(K objectToLock, V context) {
            this.id = objectToLock;
            this.contexts.add(context);
        }

        @Override
        public boolean canObtainReadLock(V context) {
            return true;
        }

        @Override
        public boolean canObtainWriteLock(V context) {
            return this.contexts.size() == 1 && this.contexts.contains(context);
        }

        @Override
        public LockEntry<K, V> readLock(V context) {
            this.contexts.add(context);
            return this;
        }

        @Override
        public LockEntry<K, V> writeLock(V context) {
            return new WriteLockEntry<K, V>(this.id, context, this);
        }

        @Override
        public K getKey() {
            return this.id;
        }

        @Override
        public LockEntry<K, V> readUnlock(V context) {
            this.contexts.remove(context);
            return this.contexts.isEmpty() ? null : this;
        }

        @Override
        public LockEntry<K, V> writeUnlock(V context) {
            throw new IllegalMonitorStateException();
        }

        @Override
        public boolean isReadLock(V context) {
            return this.contexts.contains(context);
        }

        @Override
        public boolean isWriteLock(V context) {
            return false;
        }

        @Override
        public boolean isReadLockByOthers(V context) {
            if (this.contexts.isEmpty()) {
                return false;
            }
            return this.contexts.size() > (this.isReadLock(context) ? 1 : 0);
        }

        @Override
        public boolean isWriteLockByOthers(V context) {
            return false;
        }

        @Override
        public LockEntry<K, V> clearLock(V context) {
            while (this.contexts.remove(context)) {
            }
            return this.contexts.isEmpty() ? null : this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteLockEntry<K, V>
    implements LockEntry<K, V> {
        private K objectToLock;
        private V context;
        private int count;
        private ReadLockEntry<K, V> readLock;

        public WriteLockEntry(K objectToLock, V context, ReadLockEntry<K, V> readLock) {
            this.objectToLock = objectToLock;
            this.context = context;
            this.readLock = readLock;
            this.count = 1;
        }

        private ReadLockEntry<K, V> getReadLock() {
            if (this.readLock == null) {
                this.readLock = new ReadLockEntry<K, V>(this.objectToLock, this.context);
            }
            return this.readLock;
        }

        @Override
        public boolean canObtainWriteLock(V context) {
            return context == this.context;
        }

        @Override
        public boolean canObtainReadLock(V context) {
            return context == this.context;
        }

        @Override
        public LockEntry<K, V> readLock(V context) {
            this.getReadLock().readLock(context);
            return this;
        }

        @Override
        public LockEntry<K, V> writeLock(V context) {
            ++this.count;
            return this;
        }

        @Override
        public K getKey() {
            return this.objectToLock;
        }

        @Override
        public LockEntry<K, V> readUnlock(V context) {
            if (this.readLock != null) {
                if (this.getReadLock().readUnlock(context) == null) {
                    this.readLock = null;
                }
                return this;
            }
            throw new IllegalMonitorStateException();
        }

        @Override
        public LockEntry<K, V> writeUnlock(V context) {
            return --this.count <= 0 ? this.readLock : this;
        }

        @Override
        public boolean isReadLock(V context) {
            return this.readLock != null ? this.readLock.isReadLock(context) : false;
        }

        @Override
        public boolean isWriteLock(V context) {
            return context == this.context;
        }

        @Override
        public LockEntry<K, V> clearLock(V context) {
            if (this.readLock != null && this.getReadLock().clearLock(context) == null) {
                this.readLock = null;
            }
            return this.context == context ? this.readLock : this;
        }

        @Override
        public boolean isReadLockByOthers(V context) {
            return this.readLock != null ? this.readLock.isReadLockByOthers(context) : false;
        }

        @Override
        public boolean isWriteLockByOthers(V context) {
            return context != this.context;
        }
    }
}

