/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.NotYetImplementedException;
import org.eclipse.net4j.internal.jms.SessionImpl;
import org.eclipse.net4j.internal.jms.bundle.OM;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class MessageConsumerImpl
extends Lifecycle
implements MessageConsumer {
    private static final long DO_NOT_WAIT = -1L;
    private SessionImpl session;
    private long consumerID;
    private DestinationImpl destination;
    private String messageSelector;
    private MessageListener messageListener;
    private BlockingQueue<MessageImpl> messages = new LinkedBlockingQueue<MessageImpl>();

    public MessageConsumerImpl(SessionImpl session, long consumerID, DestinationImpl destination, String messageSelector) {
        this.session = session;
        this.consumerID = consumerID;
        this.destination = destination;
        this.messageSelector = messageSelector;
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public DestinationImpl getDestination() {
        return this.destination;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
        if (this.messageListener != null) {
            this.session.addWork((Object)this);
        }
    }

    public Message receive() throws JMSException {
        return this.receive(Long.MAX_VALUE);
    }

    public Message receive(long timeout) throws JMSException {
        if (this.messageListener != null) {
            throw new JMSException("Consumer is configured for asynchronous delivery");
        }
        if (timeout == -1L) {
            return (Message)this.messages.poll();
        }
        try {
            return this.messages.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public Message receiveNoWait() throws JMSException {
        return this.receive(-1L);
    }

    public void close() {
        throw new NotYetImplementedException();
    }

    public void handleServerMessage(MessageImpl message) {
        this.messages.add(message);
        if (this.messageListener != null) {
            this.session.addWork((Object)this);
        }
    }

    public void dispatchMessage() {
        MessageListener listener = this.messageListener;
        if (listener != null) {
            MessageImpl message = (MessageImpl)this.messages.poll();
            if (message == null) {
                OM.LOG.warn("No message to dispatch");
                return;
            }
            try {
                listener.onMessage((Message)message);
                if (!this.session.getTransacted() && this.session.getAcknowledgeMode() != 2) {
                    this.session.acknowledgeMessages(this);
                }
            }
            catch (RuntimeException ex) {
                OM.LOG.warn((Throwable)ex);
            }
        }
    }
}

