/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.internal;

import org.eclipse.emf.ecore.xml.type.InvalidDatatypeValueException;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;

public final class XMLDuration {
    private final String ERROR_MESSAGE = "The 'duration' value is invalid: ";
    private static final int[][] DATETIMES;
    private int hashCode = 0;
    final int[] dateValue;
    final String valueString;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[8];
        nArray[0] = 1696;
        nArray[1] = 9;
        nArray[2] = 1;
        nArray[7] = 90;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1697;
        nArray2[1] = 2;
        nArray2[2] = 1;
        nArray2[7] = 90;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 1903;
        nArray3[1] = 3;
        nArray3[2] = 1;
        nArray3[7] = 90;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 1903;
        nArray4[1] = 7;
        nArray4[2] = 1;
        nArray4[7] = 90;
        nArrayArray[3] = nArray4;
        DATETIMES = nArrayArray;
    }

    public XMLDuration(String value) {
        this.dateValue = this.parse(value);
        this.valueString = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XMLDuration)) {
            return false;
        }
        int[] odata = ((XMLDuration)obj).dateValue;
        return XMLDuration.compareDates(this.dateValue, odata, true) == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int[] temp = XMLDuration.addDuration(this.dateValue, DATETIMES[0], new int[9]);
            int i = 0;
            while (i < 9) {
                this.hashCode ^= temp[i];
                ++i;
            }
        }
        return this.hashCode;
    }

    public static int compare(XMLDuration value1, XMLDuration value2) {
        return XMLDuration.compareDates(value1.dateValue, value2.dateValue, true);
    }

    private int[] parse(String str) throws InvalidDatatypeValueException {
        int end;
        char c;
        int len = str.length();
        int[] date = new int[9];
        int start = 0;
        if ((c = str.charAt(start++)) != 'P' && c != '-') {
            throw new InvalidDatatypeValueException("The 'duration' value is invalid: " + str);
        }
        int n = date[8] = c == '-' ? 45 : 0;
        if (c == '-' && str.charAt(start++) != 'P') {
            throw new InvalidDatatypeValueException("The 'duration' value is invalid: " + str);
        }
        int negate = 1;
        if (date[8] == 45) {
            negate = -1;
        }
        boolean designator = false;
        int endDate = XMLCalendar.indexOf(str, start, len, 'T');
        if (endDate == -1) {
            endDate = len;
        }
        if ((end = XMLCalendar.indexOf(str, start, endDate, 'Y')) != -1) {
            date[0] = negate * XMLCalendar.parseInt(str, start, end);
            start = end + 1;
            designator = true;
        }
        if ((end = XMLCalendar.indexOf(str, start, endDate, 'M')) != -1) {
            date[1] = negate * XMLCalendar.parseInt(str, start, end);
            start = end + 1;
            designator = true;
        }
        if ((end = XMLCalendar.indexOf(str, start, endDate, 'D')) != -1) {
            date[2] = negate * XMLCalendar.parseInt(str, start, end);
            start = end + 1;
            designator = true;
        }
        if (len == endDate && start != len) {
            throw new InvalidDatatypeValueException("The 'duration' value is invalid: " + str);
        }
        if (len != endDate) {
            if ((end = XMLCalendar.indexOf(str, ++start, len, 'H')) != -1) {
                date[3] = negate * XMLCalendar.parseInt(str, start, end);
                start = end + 1;
                designator = true;
            }
            if ((end = XMLCalendar.indexOf(str, start, len, 'M')) != -1) {
                date[4] = negate * XMLCalendar.parseInt(str, start, end);
                start = end + 1;
                designator = true;
            }
            if ((end = XMLCalendar.indexOf(str, start, len, 'S')) != -1) {
                int mlsec = XMLCalendar.indexOf(str, start, end, '.');
                if (mlsec > 0) {
                    date[5] = negate * XMLCalendar.parseInt(str, start, mlsec);
                    date[6] = negate * XMLCalendar.parseInt(str, mlsec + 1, end);
                } else {
                    date[5] = negate * XMLCalendar.parseInt(str, start, end);
                }
                start = end + 1;
                designator = true;
            }
            if (start != len || str.charAt(--start) == 'T') {
                throw new InvalidDatatypeValueException("The 'duration' value is invalid: " + str);
            }
        }
        if (!designator) {
            throw new InvalidDatatypeValueException("The 'duration' value is invalid: " + str);
        }
        return date;
    }

    protected static short compareDates(int[] date1, int[] date2, boolean strict) {
        int[] tempB;
        short resultB = 2;
        short resultA = XMLCalendar.compareOrder(date1, date2);
        if (resultA == 0) {
            return 0;
        }
        int[][] result = new int[2][9];
        int[] tempA = XMLDuration.addDuration(date1, DATETIMES[0], result[0]);
        resultA = XMLCalendar.compareOrder(tempA, tempB = XMLDuration.addDuration(date2, DATETIMES[0], result[1]));
        if (resultA == 2) {
            return 2;
        }
        tempA = XMLDuration.addDuration(date1, DATETIMES[1], result[0]);
        resultB = XMLCalendar.compareOrder(tempA, tempB = XMLDuration.addDuration(date2, DATETIMES[1], result[1]));
        if ((resultA = XMLDuration.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = XMLDuration.addDuration(date1, DATETIMES[2], result[0]);
        resultB = XMLCalendar.compareOrder(tempA, tempB = XMLDuration.addDuration(date2, DATETIMES[2], result[1]));
        if ((resultA = XMLDuration.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = XMLDuration.addDuration(date1, DATETIMES[3], result[0]);
        tempB = XMLDuration.addDuration(date2, DATETIMES[3], result[1]);
        resultB = XMLCalendar.compareOrder(tempA, tempB);
        resultA = XMLDuration.compareResults(resultA, resultB, strict);
        return resultA;
    }

    private static short compareResults(short resultA, short resultB, boolean strict) {
        if (resultB == 2) {
            return 2;
        }
        if (resultA != resultB && strict) {
            return 2;
        }
        if (resultA != resultB && !strict) {
            if (resultA != 0 && resultB != 0) {
                return 2;
            }
            return resultA != 0 ? resultA : resultB;
        }
        return resultA;
    }

    private static int[] addDuration(int[] date, int[] addto, int[] duration) {
        XMLCalendar.resetDateObj(duration);
        int temp = addto[1] + date[1];
        duration[1] = XMLCalendar.modulo(temp, 1, 13);
        int carry = XMLCalendar.fQuotient(temp, 1, 13);
        duration[0] = addto[0] + date[0] + carry;
        temp = addto[6] + date[6];
        carry = XMLCalendar.fQuotient(temp, 1000);
        duration[6] = XMLCalendar.mod(temp, 1000, carry);
        temp = addto[5] + date[5];
        carry = XMLCalendar.fQuotient(temp, 60);
        duration[5] = XMLCalendar.mod(temp, 60, carry);
        temp = addto[4] + date[4] + carry;
        carry = XMLCalendar.fQuotient(temp, 60);
        duration[4] = XMLCalendar.mod(temp, 60, carry);
        temp = addto[3] + date[3] + carry;
        carry = XMLCalendar.fQuotient(temp, 24);
        duration[3] = XMLCalendar.mod(temp, 24, carry);
        duration[2] = addto[2] + date[2] + carry;
        while (true) {
            temp = XMLCalendar.maxDayInMonthFor(duration[0], duration[1]);
            if (duration[2] < 1) {
                duration[2] = duration[2] + XMLCalendar.maxDayInMonthFor(duration[0], duration[1] - 1);
                carry = -1;
            } else {
                if (duration[2] <= temp) break;
                duration[2] = duration[2] - temp;
                carry = 1;
            }
            temp = duration[1] + carry;
            duration[1] = XMLCalendar.modulo(temp, 1, 13);
            duration[0] = duration[0] + XMLCalendar.fQuotient(temp, 1, 13);
        }
        duration[8] = 90;
        return duration;
    }

    public String toString() {
        return this.valueString;
    }
}

