/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSubscriptionRequest
extends CDOClientRequest<Boolean> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ChangeSubscriptionRequest.class);
    private int viewID;
    private List<CDOID> cdoIDs;
    private boolean subscribeMode;
    private boolean clear;

    public ChangeSubscriptionRequest(CDOClientProtocol protocol, int viewID, List<CDOID> cdoIDs, boolean subscribeMode, boolean clear) {
        super(protocol, (short)22);
        this.viewID = viewID;
        this.cdoIDs = cdoIDs;
        this.subscribeMode = subscribeMode;
        this.clear = clear;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.trace("View " + this.viewID + " subscribing to " + this.cdoIDs.size());
        }
        out.writeInt(this.viewID);
        out.writeBoolean(this.clear);
        out.writeInt(this.subscribeMode ? this.cdoIDs.size() : -this.cdoIDs.size());
        for (CDOID id : this.cdoIDs) {
            out.writeCDOID(id);
        }
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        return in.readBoolean();
    }
}

