/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.Audit;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.internal.server.protocol.CommitNotificationRequest;
import org.eclipse.emf.cdo.internal.server.protocol.RemoteSessionNotificationRequest;
import org.eclipse.emf.cdo.server.IAudit;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.SessionCreationException;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.options.IOptionsContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
extends Container<IView>
implements ISession,
CDOIDProvider,
CDOCommonSession.Options {
    private SessionManager sessionManager;
    private CDOServerProtocol protocol;
    private int sessionID;
    private String userID;
    private boolean passiveUpdateEnabled = true;
    private ConcurrentMap<Integer, IView> views = new ConcurrentHashMap<Integer, IView>();
    @ReflectUtil.ExcludeFromDump
    private IListener protocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            Session.this.deactivate();
        }
    };
    private boolean subscribed;

    public Session(SessionManager sessionManager, CDOServerProtocol protocol, int sessionID, String userID) throws SessionCreationException {
        this.sessionManager = sessionManager;
        this.protocol = protocol;
        this.sessionID = sessionID;
        this.userID = userID;
        protocol.addListener(this.protocolListener);
        try {
            this.activate();
        }
        catch (Exception ex) {
            throw new SessionCreationException(ex);
        }
    }

    public CDOCommonSession.Options options() {
        return this;
    }

    public IOptionsContainer getContainer() {
        return this;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.checkActive();
        if (this.subscribed != subscribed) {
            this.subscribed = subscribed;
            byte opcode = subscribed ? (byte)3 : 4;
            this.sessionManager.handleRemoteSessionNotification(opcode, this);
        }
    }

    public boolean isPassiveUpdateEnabled() {
        return this.passiveUpdateEnabled;
    }

    public void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
        this.checkActive();
        this.passiveUpdateEnabled = passiveUpdateEnabled;
    }

    public View[] getElements() {
        this.checkActive();
        return this.getViews();
    }

    public boolean isEmpty() {
        this.checkActive();
        return this.views.isEmpty();
    }

    public View[] getViews() {
        this.checkActive();
        return this.getViewsArray();
    }

    private View[] getViewsArray() {
        return this.views.values().toArray(new View[this.views.size()]);
    }

    public IView getView(int viewID) {
        this.checkActive();
        return (IView)this.views.get(viewID);
    }

    @Override
    public IView openView(int viewID) {
        this.checkActive();
        View view = new View(this, viewID);
        this.addView(view);
        return view;
    }

    @Override
    public IAudit openAudit(int viewID, long timeStamp) {
        this.checkActive();
        Audit audit = new Audit(this, viewID, timeStamp);
        this.addView(audit);
        return audit;
    }

    @Override
    public ITransaction openTransaction(int viewID) {
        this.checkActive();
        Transaction transaction = new Transaction(this, viewID);
        this.addView(transaction);
        return transaction;
    }

    private void addView(IView view) {
        this.checkActive();
        this.views.put(view.getViewID(), view);
        this.fireElementAddedEvent(view);
    }

    public void viewClosed(View view) {
        if (this.views.remove(view.getViewID()) == view) {
            view.doClose();
            this.fireElementRemovedEvent(view);
        }
    }

    public void handleCommitNotification(long timeStamp, CDOPackageUnit[] packageUnits, List<CDOIDAndVersion> dirtyIDs, List<CDOID> detachedObjects, List<CDORevisionDelta> deltas) {
        View view;
        int n;
        int n2;
        View[] viewArray;
        if (!this.isPassiveUpdateEnabled()) {
            dirtyIDs = Collections.emptyList();
        }
        ArrayList<CDORevisionDelta> newDeltas = new ArrayList<CDORevisionDelta>();
        block2: for (CDORevisionDelta delta : deltas) {
            CDOID lookupID = delta.getID();
            viewArray = this.getViews();
            n2 = viewArray.length;
            n = 0;
            while (n < n2) {
                view = viewArray[n];
                if (view.hasSubscription(lookupID)) {
                    newDeltas.add(delta);
                    continue block2;
                }
                ++n;
            }
        }
        if (!this.isPassiveUpdateEnabled()) {
            ArrayList<CDOID> subDetached = new ArrayList<CDOID>();
            block4: for (CDOID id : detachedObjects) {
                viewArray = this.getViews();
                n2 = viewArray.length;
                n = 0;
                while (n < n2) {
                    view = viewArray[n];
                    if (view.hasSubscription(id)) {
                        subDetached.add(id);
                        continue block4;
                    }
                    ++n;
                }
            }
            detachedObjects = subDetached;
        }
        try {
            if (!(dirtyIDs.isEmpty() && newDeltas.isEmpty() && detachedObjects.isEmpty() && packageUnits.length <= 0)) {
                IChannel channel = this.protocol.getChannel();
                if (LifecycleUtil.isActive((Object)channel)) {
                    new CommitNotificationRequest(channel, timeStamp, packageUnits, dirtyIDs, detachedObjects, newDeltas).sendAsync();
                } else {
                    OM.LOG.warn("Session channel is inactive: " + this);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public void handleRemoteSessionNotification(byte opcode, ISession session) {
        try {
            IChannel channel = this.protocol.getChannel();
            if (LifecycleUtil.isActive((Object)channel)) {
                new RemoteSessionNotificationRequest(channel, opcode, session).sendAsync();
            } else {
                OM.LOG.warn("Session channel is inactive: " + this);
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public CDOID provideCDOID(Object idObject) {
        return (CDOID)idObject;
    }

    public void collectContainedRevisions(InternalCDORevision revision, int referenceChunk, Set<CDOID> revisions, List<CDORevision> additionalRevisions) {
        RevisionManager revisionManager = (RevisionManager)this.getSessionManager().getRepository().getRevisionManager();
        EClass eClass = revision.getEClass();
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int i = 0;
        while (i < features.length) {
            CDOID id;
            Object value;
            EStructuralFeature feature = features[i];
            if (feature instanceof EReference && !feature.isMany() && ((EReference)feature).isContainment() && (value = revision.getValue(feature)) instanceof CDOID && !CDOIDUtil.isNull((CDOID)(id = (CDOID)value)) && !revisions.contains(id)) {
                InternalCDORevision containedRevision = revisionManager.getRevision(id, referenceChunk);
                revisions.add(id);
                additionalRevisions.add((CDORevision)containedRevision);
                this.collectContainedRevisions(containedRevision, referenceChunk, revisions, additionalRevisions);
            }
            ++i;
        }
    }

    public String toString() {
        return MessageFormat.format("Session[{0}]", this.sessionID);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    protected void doDeactivate() throws Exception {
        this.protocol.removeListener(this.protocolListener);
        this.protocol = null;
        this.protocolListener = null;
        View[] viewArray = this.getViewsArray();
        int n = viewArray.length;
        int n2 = 0;
        while (n2 < n) {
            View view = viewArray[n2];
            view.close();
            ++n2;
        }
        this.views = null;
        this.sessionManager.sessionClosed(this);
        this.sessionManager = null;
        super.doDeactivate();
    }
}

