/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertySetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;

public class CDOIDPropertySetter
extends CDOPropertySetter {
    private static final long serialVersionUID = 1L;

    public CDOIDPropertySetter(CDORevisionTuplizer tuplizer, String propertyName) {
        super(tuplizer, propertyName);
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        InternalCDORevision revision;
        CDOID cdoID;
        if (value == null) {
            return;
        }
        HibernateCommitContext hcc = null;
        if (HibernateThreadContext.isHibernateCommitContextSet()) {
            hcc = HibernateThreadContext.getHibernateCommitContext();
        }
        if ((cdoID = (revision = (InternalCDORevision)target).getID()) == null) {
            CDOIDHibernate newCDOID = CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)value, revision.getEClass().getName());
            revision.setID((CDOID)newCDOID);
            if (hcc != null) {
                hcc.setNewID(cdoID, (CDOID)newCDOID);
            }
        } else if (cdoID instanceof CDOIDTemp) {
            CDOIDHibernate newCDOID = CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)value, revision.getEClass().getName());
            revision.setID((CDOID)newCDOID);
            if (hcc != null) {
                hcc.getCommitContext().addIDMapping((CDOIDTemp)cdoID, (CDOID)newCDOID);
                hcc.setNewID(cdoID, (CDOID)newCDOID);
            }
        } else {
            CDOIDHibernate hbCDOID = (CDOIDHibernate)revision.getID();
            if (hbCDOID.getId() == null) {
                hbCDOID.setId((Serializable)value);
            } else if (!hbCDOID.getId().equals(value)) {
                throw new IllegalStateException("Current id and new id are different " + value + "/" + hbCDOID.getId());
            }
        }
        if (!this.isVirtualProperty()) {
            super.set(target, value, factory);
        }
    }

    protected boolean isVirtualPropertyAllowed() {
        return true;
    }
}

