/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionTuplizer;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class CDORevisionPropertyAccessor
implements PropertyAccessor {
    private CDORevisionTuplizer tuplizer;

    public CDORevisionPropertyAccessor(CDORevisionTuplizer tuplizer) {
        this.tuplizer = tuplizer;
    }

    public CDORevisionTuplizer getTuplizer() {
        return this.tuplizer;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new CDORevisionGetter(this, propertyName);
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new CDORevisionSetter(this, propertyName);
    }

    public static class BaseAccessor {
        private CDORevisionPropertyAccessor propertyAccessor;
        private CDOFeature cdoFeature;

        public BaseAccessor(CDORevisionPropertyAccessor propertyAccessor, String propertyName) {
            this.propertyAccessor = propertyAccessor;
            this.cdoFeature = propertyAccessor.getTuplizer().getCDOClass().lookupFeature(propertyName);
            if (this.cdoFeature == null) {
                throw new IllegalStateException("Feature not found: " + propertyName);
            }
        }

        public CDORevisionPropertyAccessor getPropertyAccessor() {
            return this.propertyAccessor;
        }

        public CDOFeature getCDOFeature() {
            return this.cdoFeature;
        }
    }

    public static class CDORevisionGetter
    extends BaseAccessor
    implements Getter {
        private static final long serialVersionUID = 1L;

        public CDORevisionGetter(CDORevisionPropertyAccessor propertyAccessor, String propertyName) {
            super(propertyAccessor, propertyName);
        }

        public Object get(Object target) throws HibernateException {
            InternalCDORevision revision = (InternalCDORevision)target;
            return revision.getValue(this.getCDOFeature());
        }

        public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) throws HibernateException {
            return this.get(target);
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class getReturnType() {
            return Object.class;
        }
    }

    public static class CDORevisionSetter
    extends BaseAccessor
    implements Setter {
        private static final long serialVersionUID = 1L;

        public CDORevisionSetter(CDORevisionPropertyAccessor propertyAccessor, String propertyName) {
            super(propertyAccessor, propertyName);
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            InternalCDORevision revision = (InternalCDORevision)target;
            revision.setValue(this.getCDOFeature(), value);
        }
    }
}

