/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStoreReader;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateStoreReader
extends HibernateStoreAccessor
implements IHibernateStoreReader {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStoreReader.class);

    public HibernateStoreReader(HibernateStore store, ISession session) {
        super(store, session);
        HibernateThreadContext.setCurrentHibernateStoreAccessor(this);
    }

    protected HibernateStoreReader(HibernateStore store, IView view) {
        super(store, view);
        HibernateThreadContext.setCurrentHibernateStoreAccessor(this);
    }

    @Override
    public HibernateStoreChunkReader createChunkReader(CDORevision revision, CDOFeature feature) {
        return new HibernateStoreChunkReader(this, revision, feature);
    }

    public CloseableIterator<CDOID> readObjectIDs(boolean withTypes) {
        throw new UnsupportedOperationException();
    }

    public CDOClassRef readObjectType(CDOID id) {
        CDORevision cdoRevision = this.readRevision(id, -1);
        return cdoRevision.getCDOClass().createClassRef();
    }

    public void readPackage(CDOPackage cdoPackage) {
        this.getStore().getPackageHandler().readPackage(cdoPackage);
    }

    public Collection<CDOPackageInfo> readPackageInfos() {
        return this.getStore().getPackageHandler().getCDOPackageInfos();
    }

    public CDOID readResourceID(String path) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Finding resourceid using path " + path);
        }
        Session session = this.getHibernateSession();
        Criteria criteria = session.createCriteria("CDOResource");
        criteria.add((Criterion)Expression.eq((String)"path", (Object)path));
        List result = criteria.list();
        if (result.size() == 0) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Resource not found");
            }
            return null;
        }
        CDORevision cdoRevision = (CDORevision)result.get(0);
        return cdoRevision.getID();
    }

    public String readResourcePath(CDOID id) {
        if (id == null) {
            throw new IllegalArgumentException("ID must be not null");
        }
        if (!(id instanceof CDOIDHibernate)) {
            throw new IllegalArgumentException("ID type " + id.getClass().getName() + " not supported by hibernate reader");
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Finding resource using id " + id);
        }
        Session session = this.getHibernateSession();
        Query qry = session.createQuery("select path from CDOResource where id=:id");
        CDOIDHibernate idHibernate = (CDOIDHibernate)id;
        qry.setParameter("id", (Object)idHibernate.getId());
        List result = qry.list();
        if (result.size() == 0) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Resource not found");
            }
            return null;
        }
        return (String)result.get(0);
    }

    public CDORevision readRevision(CDOID id, int referenceChunk) {
        return HibernateUtil.getInstance().getCDORevision(id);
    }

    public CDORevision readRevisionByTime(CDOID id, int referenceChunk, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public CDORevision readRevisionByVersion(CDOID id, int referenceChunk, int version) {
        throw new UnsupportedOperationException();
    }

    public void refreshRevisions() {
    }
}

