/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ecore;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ModelImporterApplication;
import org.eclipse.emf.importer.ecore.EcoreImporter;

public class EcoreImporterApplication
extends ModelImporterApplication {
    protected Map nameToPackageInfo;

    public EcoreImporter getEcoreImporter() {
        return (EcoreImporter)this.getModelImporter();
    }

    protected ModelImporter createModelImporter() {
        return new EcoreImporter();
    }

    protected StringBuffer getUsage() {
        StringBuffer result = new StringBuffer();
        this.appendLine(result, "Usage: { <model.ecore> }+ [ <model.genmodel> [ -reload ] ] <OPTION>");
        this.appendLine(result, "<OPTION>          ::= [ <PROJECT-OPTION> ]  [ <PATHMAP> ]");
        this.appendLine(result, "                      { <PACKAGE> }+  { <REF-PACKAGE> }* { <REF-GEN-MODEL> }*");
        this.appendLine(result, "                      [ <TEMPLATE-PATH> ] [ <MODEL-PLUGIN-ID> ] [ <COPYRIGHT> ]");
        this.appendLine(result, "                      [ <SDO> ] [ <QUIET> ]");
        this.appendLine(result, "<PROJECT-OPTION>  ::= <MODEL-PROJECT> [ <EDIT-PROJECT> ] [ <EDITOR-PROJECT> ]");
        this.appendLine(result, "                      [ <TESTS-PROJECT> ]");
        this.appendLine(result, "<MODEL-PROJECT>   ::= -modelProject <model-directory> <fragment-path>");
        this.appendLine(result, "<EDIT-PROJECT>    ::= -editProject <edit-directory> <fragment-path>");
        this.appendLine(result, "<EDITOR-PROJECT>  ::= -editorProject <editor-directory> <fragment-path>");
        this.appendLine(result, "<TESTS-PROJECT>   ::= -testsProject <tests-directory> <fragment-path>");
        this.appendLine(result, "<PACKAGE>         ::= -package <nsURI> [ <base> <prefix> ]");
        this.appendLine(result, "<REF-GEN-MODEL>   ::= -refGenModel <model.genmodel> { <nsURI> }+");
        this.appendLine(result, "<TEMPLATE-PATH>   ::= -templatePath <template-directory>");
        this.appendLine(result, "<MODEL-PLUGIN-ID> ::= -modelPluginID <plugin-ID>");
        this.appendLine(result, "<COPYRIGHT>       ::= -copyright <copyright-string>");
        this.appendLine(result, "<SDO>             ::= -sdo");
        this.appendLine(result, "<QUIET>           ::= -quiet");
        this.appendLine(result, "");
        this.appendLine(result, "For example:");
        this.appendLine(result, "");
        this.appendLine(result, "");
        this.appendLine(result, "  ecore2genmodel");
        this.appendLine(result, "    ../../etools.company/model.ecore");
        this.appendLine(result, "    result/model/Extended.genmodel");
        this.appendLine(result, "    -modelProject result src");
        this.appendLine(result, "    -editProject result.edit src");
        this.appendLine(result, "    -editorProject result.editor src");
        this.appendLine(result, "    -refGenModel company.genmodel http://org.sample.company");
        return result;
    }

    protected void processArguments(String[] arguments, int index) {
        index = this.processModelAndGenModelLocationArguments(arguments, index);
        super.processArguments(arguments, index);
    }

    protected int processArgument(String[] arguments, int index) {
        if (arguments[index].equalsIgnoreCase("-package")) {
            if (this.nameToPackageInfo == null) {
                this.nameToPackageInfo = new HashMap();
            }
        } else {
            return super.processArgument(arguments, index);
        }
        index = this.processPackageInformation(arguments, index, this.nameToPackageInfo);
        return index + 1;
    }

    protected int processPackageInformation(String[] arguments, int index, Map nsURIToPackageInfo) {
        int start = index;
        PackageInfo packageInfo = new PackageInfo();
        if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
            packageInfo.nsURI = arguments[++index];
            if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                packageInfo.base = arguments[++index];
                if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                    packageInfo.prefix = arguments[++index];
                }
            }
            if (index - start != 1 && index - start != 3) {
                throw new IllegalArgumentException("Error: Expecting either 1 or 3 arguments for " + arguments[start]);
            }
            nsURIToPackageInfo.put(packageInfo.nsURI, packageInfo);
            nsURIToPackageInfo.put(packageInfo.nsURI.toLowerCase(), packageInfo);
            return index;
        }
        throw new IllegalArgumentException("Error: No package name was specified for " + arguments[start]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void adjustEPackages(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            List ePackages = this.getEcoreImporter().getEPackages();
            this.traverseEPackages(ePackages);
            this.getEcoreImporter().adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    protected void traverseEPackages(List ePackages) {
        Iterator i = ePackages.iterator();
        while (i.hasNext()) {
            PackageInfo packageInfo;
            EPackage ePackage = (EPackage)i.next();
            if (this.nameToPackageInfo != null && (packageInfo = (PackageInfo)this.nameToPackageInfo.get(ePackage.getNsURI())) != null) {
                this.handleEPackage(ePackage, true);
                ModelImporter.EPackageImportInfo ePackageInfo = this.getEcoreImporter().getEPackageImportInfo(ePackage);
                if (ePackageInfo.getBasePackage() == null) {
                    ePackageInfo.setBasePackage(packageInfo.base);
                }
                if (ePackageInfo.getPrefix() == null) {
                    ePackageInfo.setPrefix(packageInfo.prefix);
                }
            }
            this.handleQualifiedEPackageName(ePackage);
            this.traverseEPackages((List)ePackage.getESubpackages());
        }
    }

    public static class PackageInfo {
        public String nsURI;
        public String base;
        public String prefix;
    }
}

