/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.PackageClosure;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletePackageClosure
extends PackageClosure {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CompletePackageClosure.class);
    private boolean excludeEcore;

    public CompletePackageClosure() {
    }

    public CompletePackageClosure(boolean excludeEcore) {
        this.excludeEcore = excludeEcore;
    }

    @Override
    protected void collectContents(EPackage ePackage, Set<EPackage> visited) {
        if (ePackage != null && visited.add(ePackage)) {
            if (this.excludeEcore && ePackage == EcorePackage.eINSTANCE) {
                return;
            }
            HashSet<EClass> classes = new HashSet<EClass>();
            EList classifiers = ePackage.getEClassifiers();
            for (EClassifier classifier : classifiers) {
                this.handleEClassifier(classifier, classes);
            }
            for (EClass eClass : classes) {
                EPackage p = eClass.getEPackage();
                if (p != null) {
                    if (!visited.add(p) || !TRACER.isEnabled()) continue;
                    TRACER.trace("Found package " + p.getNsURI());
                    continue;
                }
                OM.LOG.warn("Package == null for " + eClass.getName());
            }
        }
    }

    protected void handleEClassifiers(List<EClassifier> classifiers, Set<EClass> visited) {
        if (classifiers != null) {
            for (EClassifier classifier : classifiers) {
                this.handleEClassifier(classifier, visited);
            }
        }
    }

    protected void handleEClassifier(EClassifier classifier, Set<EClass> visited) {
        if (classifier instanceof EClass) {
            this.handleEClass((EClass)classifier, visited);
        }
    }

    protected void handleEClasses(List<EClass> classes, Set<EClass> visited) {
        if (classes != null) {
            for (EClass eClass : classes) {
                this.handleEClass(eClass, visited);
            }
        }
    }

    protected void handleEClass(EClass eClass, Set<EClass> visited) {
        if (eClass != null && visited.add(eClass)) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Found class " + eClass.getName());
            }
            this.handleEStructuralFeatures((List<EStructuralFeature>)eClass.getEStructuralFeatures(), visited);
            this.handleEOperations((List<EOperation>)eClass.getEOperations(), visited);
            this.handleEClasses((List<EClass>)eClass.getESuperTypes(), visited);
            this.handleEGenericTypes((EList<EGenericType>)eClass.getEGenericSuperTypes(), visited);
            this.handleETypeParameters((EList<ETypeParameter>)eClass.getETypeParameters(), visited);
        }
    }

    protected void handleEStructuralFeatures(List<EStructuralFeature> structuralFeatures, Set<EClass> visited) {
        if (structuralFeatures != null) {
            for (EStructuralFeature structuralFeature : structuralFeatures) {
                this.handleEClassifier(structuralFeature.getEType(), visited);
                this.handleEGenericType(structuralFeature.getEGenericType(), visited);
            }
        }
    }

    protected void handleEOperations(List<EOperation> operations, Set<EClass> visited) {
        if (operations != null) {
            for (EOperation operation : operations) {
                this.handleEClassifier(operation.getEType(), visited);
                this.handleEGenericType(operation.getEGenericType(), visited);
                this.handleETypeParameters((EList<ETypeParameter>)operation.getETypeParameters(), visited);
                this.handleEParameters((List<EParameter>)operation.getEParameters(), visited);
                this.handleEClassifiers((List<EClassifier>)operation.getEExceptions(), visited);
                this.handleEGenericTypes((EList<EGenericType>)operation.getEGenericExceptions(), visited);
            }
        }
    }

    protected void handleEParameters(List<EParameter> parameters, Set<EClass> visited) {
        if (parameters != null) {
            for (EParameter parameter : parameters) {
                this.handleEClassifier(parameter.getEType(), visited);
                this.handleEGenericType(parameter.getEGenericType(), visited);
            }
        }
    }

    protected void handleEGenericTypes(EList<EGenericType> genericTypes, Set<EClass> visited) {
        if (genericTypes != null) {
            for (EGenericType genericType : genericTypes) {
                this.handleEGenericType(genericType, visited);
            }
        }
    }

    protected void handleEGenericType(EGenericType genericType, Set<EClass> visited) {
        if (genericType != null) {
            this.handleEClassifier(genericType.getEClassifier(), visited);
            this.handleEClassifier(genericType.getERawType(), visited);
            this.handleEGenericType(genericType.getELowerBound(), visited);
            this.handleEGenericType(genericType.getEUpperBound(), visited);
            this.handleEGenericTypes((EList<EGenericType>)genericType.getETypeArguments(), visited);
            this.handleETypeParameter(genericType.getETypeParameter(), visited);
        }
    }

    protected void handleETypeParameters(EList<ETypeParameter> typeParameters, Set<EClass> visited) {
        if (typeParameters != null) {
            for (ETypeParameter typeParameter : typeParameters) {
                this.handleETypeParameter(typeParameter, visited);
            }
        }
    }

    protected void handleETypeParameter(ETypeParameter typeParameter, Set<EClass> visited) {
        if (typeParameter != null) {
            this.handleEGenericTypes((EList<EGenericType>)typeParameter.getEBounds(), visited);
        }
    }
}

