/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.emf.ecore.util.DelegatingFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.internal.cdo.CDOSessionPackageManagerImpl;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOStore;
import org.eclipse.emf.internal.cdo.CDOViewImpl;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.internal.cdo.util.GenUtil;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOObjectImpl
extends EStoreEObjectImpl
implements InternalCDOObject {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOObjectImpl.class);
    private CDOID id;
    private CDOState state = CDOState.TRANSIENT;
    private CDOResourceImpl resource;
    private InternalCDORevision revision;

    public CDOObjectImpl() {
        this.eContainer = null;
    }

    @Override
    public CDOID cdoID() {
        return this.id;
    }

    @Override
    public CDOState cdoState() {
        return this.state;
    }

    public InternalCDORevision cdoRevision() {
        return this.revision;
    }

    @Override
    public CDOClass cdoClass() {
        return CDOObjectImpl.getCDOClass(this);
    }

    @Override
    public CDOViewImpl cdoView() {
        return CDOObjectImpl.getCDOView(this);
    }

    @Override
    public CDOResourceImpl cdoResource() {
        if (this instanceof CDOResourceImpl) {
            this.resource = (CDOResourceImpl)this;
        }
        return this.resource;
    }

    @Override
    public void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    @Override
    public void cdoInternalSetID(CDOID id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0}", new Object[]{id});
        }
        this.id = id;
    }

    @Override
    public CDOState cdoInternalSetState(CDOState state) {
        if (this.state != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            try {
                CDOState cDOState = this.state;
                return cDOState;
            }
            finally {
                this.state = state;
            }
        }
        return null;
    }

    @Override
    public void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revision: {0}", new Object[]{revision});
        }
        this.revision = (InternalCDORevision)revision;
    }

    @Override
    public void cdoInternalSetView(CDOView view) {
        CDOViewImpl impl = (CDOViewImpl)view;
        if (this instanceof CDOResourceImpl) {
            ((CDOResourceImpl)this).cdoSetView(impl);
        }
        this.eSetStore(impl.getStore());
    }

    @Override
    public void cdoInternalSetResource(CDOResource resource) {
        if (this instanceof CDOResourceImpl) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Setting resource: {0}", new Object[]{resource});
        }
        this.resource = (CDOResourceImpl)resource;
    }

    @Override
    public void cdoInternalPostLoad() {
    }

    @Override
    public void cdoInternalPostAttach() {
        if (TRACER.isEnabled()) {
            TRACER.format("Populating revision for {0}", new Object[]{this});
        }
        CDOViewImpl view = this.cdoView();
        this.revision.setContainerID(this.eContainer == null ? CDOID.NULL : ((CDOObjectImpl)this.eContainer).cdoID());
        this.revision.setContainingFeatureID(this.eContainerFeatureID);
        if (this.eSettings == null) {
            this.eSettings();
        }
        EClass eClass = this.eClass();
        int i = 0;
        while (i < eClass.getFeatureCount()) {
            EStructuralFeature eFeature = this.cdoInternalDynamicFeature(i);
            if (!eFeature.isTransient()) {
                this.populateRevisionFeature(view, this.revision, eFeature, this.eSettings, i);
            }
            ++i;
        }
    }

    private void populateRevisionFeature(CDOViewImpl view, InternalCDORevision revision, EStructuralFeature eFeature, Object[] eSettings, int i) {
        Object setting;
        CDOFeature cdoFeature = ModelUtil.getCDOFeature(eFeature, view.getSession().getPackageManager());
        if (TRACER.isEnabled()) {
            TRACER.format("Populating feature {0}", new Object[]{cdoFeature});
        }
        if ((setting = eSettings[i]) == null) {
            setting = eFeature.getDefaultValue();
        }
        if (cdoFeature.isMany()) {
            if (setting != null) {
                int index = 0;
                EList list = (EList)setting;
                for (Object value : list) {
                    if (cdoFeature.isReference()) {
                        value = view.convertObjectToID(value);
                    }
                    revision.add(cdoFeature, index++, value);
                }
            }
        } else {
            if (cdoFeature.isReference()) {
                setting = view.convertObjectToID(setting);
            } else if (cdoFeature.getType() == CDOType.CUSTOM) {
                setting = EcoreUtil.convertToString((EDataType)((EDataType)eFeature.getEType()), (Object)setting);
            } else if (setting == null && GenUtil.isPrimitiveType(eFeature.getEType())) {
                setting = eFeature.getDefaultValue();
            }
            revision.set(cdoFeature, 0, setting);
        }
        if (eSettings != null) {
            eSettings[i] = null;
        }
    }

    @Override
    public void cdoInternalPostDetach() {
        if (TRACER.isEnabled()) {
            TRACER.format("Depopulating revision for {0}", new Object[]{this});
        }
        CDOViewImpl view = this.cdoView();
        this.eContainer = null;
        this.eContainerFeatureID = 0;
        if (this.eSettings == null) {
            this.eSettings();
        }
        EClass eClass = this.eClass();
        int i = 0;
        while (i < eClass.getFeatureCount()) {
            EStructuralFeature eFeature;
            Object setting = this.eSettings[i];
            if (setting != null && !(eFeature = this.cdoInternalDynamicFeature(i)).isTransient()) {
                this.depopulateRevisionFeature(view, this.revision, eFeature, this.eSettings, i);
            }
            ++i;
        }
    }

    private void depopulateRevisionFeature(CDOViewImpl view, InternalCDORevision revision, EStructuralFeature eFeature, Object[] eSettings, int i) {
        CDOFeature cdoFeature = ModelUtil.getCDOFeature(eFeature, view.getSession().getPackageManager());
        if (TRACER.isEnabled()) {
            TRACER.format("Depopulating feature {0}", new Object[]{cdoFeature});
        }
        boolean isReference = cdoFeature.isReference();
        if (cdoFeature.isMany()) {
            eSettings[i] = null;
            EList setting = (EList)super.dynamicGet(eFeature.getFeatureID());
            EList list = (EList)revision.getList(cdoFeature);
            for (Object value : list) {
                if (isReference) {
                    value = view.getObject((CDOID)value, true);
                }
                setting.add(value);
            }
        } else {
            Object value = revision.getValue(cdoFeature);
            if (isReference) {
                value = view.getObject((CDOID)value, true);
            } else if (cdoFeature.getType() == CDOType.CUSTOM) {
                value = EcoreUtil.createFromString((EDataType)((EDataType)eFeature.getEType()), (String)((String)value));
            }
            eSettings[i] = value;
        }
    }

    @Override
    public void cdoInternalPreCommit() {
    }

    @Override
    public InternalEObject cdoInternalInstance() {
        return this;
    }

    @Override
    public EStructuralFeature cdoInternalDynamicFeature(int dynamicFeatureID) {
        return this.eDynamicFeature(dynamicFeatureID);
    }

    protected FeatureMap createFeatureMap(EStructuralFeature eStructuralFeature) {
        return new CDOStoreFeatureMap(eStructuralFeature);
    }

    protected EList<?> createList(EStructuralFeature eStructuralFeature) {
        EClassifier eType = eStructuralFeature.getEType();
        if (eType.getInstanceClassName() == "java.util.Map$Entry") {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class EStoreEcoreEMap
            extends EcoreEMap<Object, Object> {
                private static final long serialVersionUID = 1L;

                public EStoreEcoreEMap(EClassifier eClassifier, EStructuralFeature eStructuralFeature) {
                    super((EClass)eClassifier, eClassifier.getInstanceClass(), null);
                    this.delegateEList = new CDOStoreEList<BasicEMap.Entry<Object, Object>>(CDOObjectImpl.this, eStructuralFeature){
                        private static final long serialVersionUID = 1L;

                        protected void didAdd(int index, BasicEMap.Entry<Object, Object> newObject) {
                            this.doPut(newObject);
                        }

                        protected void didSet(int index, BasicEMap.Entry<Object, Object> newObject, BasicEMap.Entry<Object, Object> oldObject) {
                            this.didRemove(index, oldObject);
                            this.didAdd(index, newObject);
                        }

                        protected void didRemove(int index, BasicEMap.Entry<Object, Object> oldObject) {
                            this.doRemove(oldObject);
                        }

                        protected void didClear(int size, Object[] oldObjects) {
                            this.doClear();
                        }

                        protected void didMove(int index, BasicEMap.Entry<Object, Object> movedObject, int oldIndex) {
                            this.doMove(movedObject);
                        }
                    };
                    this.size = this.delegateEList.size();
                }
            }
            return new EStoreEcoreEMap(eType, eStructuralFeature);
        }
        return new CDOStoreEList(eStructuralFeature);
    }

    protected void eInitializeContainer() {
        throw new ImplementationError();
    }

    protected void eSetDirectResource(Resource.Internal resource) {
        super.eSetDirectResource(resource);
        if (resource instanceof CDOResourceImpl) {
            this.resource = (CDOResourceImpl)resource;
        }
    }

    protected boolean eIsCaching() {
        return false;
    }

    public Object dynamicGet(int dynamicFeatureID) {
        if (FSMUtil.isTransient(this)) {
            if (this.eSettings == null) {
                return null;
            }
            return this.eSettings[dynamicFeatureID];
        }
        return super.dynamicGet(dynamicFeatureID);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        if (FSMUtil.isTransient(this)) {
            if (this.eSettings == null) {
                return false;
            }
            return this.eSettings[this.eDynamicFeatureID(feature)] != null;
        }
        return super.eIsSet(feature);
    }

    public void dynamicSet(int dynamicFeatureID, Object value) {
        if (FSMUtil.isTransient(this)) {
            this.eSettings();
            this.eSettings[dynamicFeatureID] = value;
        } else {
            super.dynamicSet(dynamicFeatureID, value);
        }
    }

    public void dynamicUnset(int dynamicFeatureID) {
        if (FSMUtil.isTransient(this)) {
            if (this.eSettings != null) {
                this.eSettings[dynamicFeatureID] = null;
            }
        } else {
            super.dynamicUnset(dynamicFeatureID);
        }
    }

    public InternalEObject eInternalContainer() {
        InternalEObject container = FSMUtil.isTransient(this) ? this.eContainer : this.getStore().getContainer(this);
        if (container instanceof CDOResource) {
            return null;
        }
        return container;
    }

    public int eContainerFeatureID() {
        if (FSMUtil.isTransient(this)) {
            return this.eContainerFeatureID;
        }
        return this.getStore().getContainingFeatureID(this);
    }

    protected void eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting container: {0}, featureID={1}", new Object[]{newContainer, newContainerFeatureID});
        }
        if (FSMUtil.isTransient(this)) {
            super.eBasicSetContainer(newContainer, newContainerFeatureID);
        } else {
            CDOResource newResource = null;
            if (newContainer instanceof CDOObject) {
                newResource = ((CDOObject)newContainer).cdoResource();
            }
            this.getStore().setContainer(this, newResource, newContainer, newContainerFeatureID);
            this.resource = (CDOResourceImpl)newResource;
            if (newContainer instanceof Resource.Internal) {
                this.eSetDirectResource((Resource.Internal)newContainer);
            }
        }
    }

    public Resource eResource() {
        CDOResourceImpl resource = this.cdoResource();
        if (resource == null && FSMUtil.isTransient(this)) {
            resource = super.eResource();
        }
        return resource;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        if (this.id == null) {
            return String.valueOf(this.eClass().getName()) + "?";
        }
        return String.valueOf(this.eClass().getName()) + "@" + this.id;
    }

    static CDOClass getCDOClass(InternalCDOObject cdoObject) {
        CDOViewImpl view = (CDOViewImpl)cdoObject.cdoView();
        CDOSessionPackageManagerImpl packageManager = view.getSession().getPackageManager();
        return ModelUtil.getCDOClass(cdoObject.eClass(), packageManager);
    }

    static CDOViewImpl getCDOView(InternalCDOObject cdoObject) {
        CDOResource resource = cdoObject.cdoResource();
        return resource != null ? (CDOViewImpl)cdoObject.cdoResource().cdoView() : null;
    }

    private CDOStore getStore() {
        return this.cdoView().getStore();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CDOStoreEList<E>
    extends DelegatingEcoreEList.Dynamic<E> {
        private static final long serialVersionUID = 1L;

        public CDOStoreEList(EStructuralFeature eStructuralFeature) {
            super((InternalEObject)CDOObjectImpl.this, eStructuralFeature);
        }

        protected boolean hasProxies() {
            return true;
        }

        protected List<E> delegateList() {
            throw new UnsupportedOperationException();
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        protected void delegateAdd(int index, Object object) {
            CDOObjectImpl.this.getStore().add(this.owner, this.eStructuralFeature, index, object);
        }

        protected void delegateAdd(Object object) {
            this.delegateAdd(this.delegateSize(), object);
        }

        protected List<E> delegateBasicList() {
            int size = this.delegateSize();
            if (size == 0) {
                return (List)ECollections.emptyEList();
            }
            Object[] data = CDOObjectImpl.this.getStore().toArray(this.owner, this.eStructuralFeature);
            return new EcoreEList.UnmodifiableEList(this.owner, this.eStructuralFeature, data.length, data);
        }

        protected void delegateClear() {
            CDOObjectImpl.this.getStore().clear(this.owner, this.eStructuralFeature);
        }

        protected boolean delegateContains(Object object) {
            return CDOObjectImpl.this.getStore().contains(this.owner, this.eStructuralFeature, object);
        }

        protected boolean delegateContainsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.delegateContains(o)) continue;
                return false;
            }
            return true;
        }

        protected E delegateGet(int index) {
            return (E)CDOObjectImpl.this.getStore().get(this.owner, this.eStructuralFeature, index);
        }

        protected int delegateHashCode() {
            return CDOObjectImpl.this.getStore().hashCode(this.owner, this.eStructuralFeature);
        }

        protected int delegateIndexOf(Object object) {
            return CDOObjectImpl.this.getStore().indexOf(this.owner, this.eStructuralFeature, object);
        }

        protected boolean delegateIsEmpty() {
            return CDOObjectImpl.this.getStore().isEmpty(this.owner, this.eStructuralFeature);
        }

        protected Iterator<E> delegateIterator() {
            return this.iterator();
        }

        protected int delegateLastIndexOf(Object object) {
            return CDOObjectImpl.this.getStore().lastIndexOf(this.owner, this.eStructuralFeature, object);
        }

        protected ListIterator<E> delegateListIterator() {
            return this.listIterator();
        }

        protected E delegateRemove(int index) {
            return (E)CDOObjectImpl.this.getStore().remove(this.owner, this.eStructuralFeature, index);
        }

        protected E delegateSet(int index, E object) {
            return (E)CDOObjectImpl.this.getStore().set(this.owner, this.eStructuralFeature, index, object);
        }

        protected int delegateSize() {
            return CDOObjectImpl.this.getStore().size(this.owner, this.eStructuralFeature);
        }

        protected Object[] delegateToArray() {
            return CDOObjectImpl.this.getStore().toArray(this.owner, this.eStructuralFeature);
        }

        protected <T> T[] delegateToArray(T[] array) {
            return CDOObjectImpl.this.getStore().toArray(this.owner, this.eStructuralFeature, array);
        }

        protected E delegateMove(int targetIndex, int sourceIndex) {
            return (E)CDOObjectImpl.this.getStore().move(this.owner, this.eStructuralFeature, targetIndex, sourceIndex);
        }

        protected boolean delegateEquals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (list.size() != this.delegateSize()) {
                return false;
            }
            ListIterator i = list.listIterator();
            while (i.hasNext()) {
                Object element = i.next();
                if (!(element == null ? this.get(i.previousIndex()) != null : !element.equals(this.get(i.previousIndex())))) continue;
                return false;
            }
            return true;
        }

        protected String delegateToString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            int i = 0;
            int size = this.size();
            while (i < size) {
                E value = this.delegateGet(i);
                stringBuffer.append(String.valueOf(value));
                if (++i >= size) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CDOStoreFeatureMap
    extends DelegatingFeatureMap {
        private static final long serialVersionUID = 1L;

        public CDOStoreFeatureMap(EStructuralFeature eStructuralFeature) {
            super((InternalEObject)CDOObjectImpl.this, eStructuralFeature);
        }

        protected boolean hasProxies() {
            return true;
        }

        protected List<FeatureMap.Entry> delegateList() {
            throw new UnsupportedOperationException();
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        protected void delegateAdd(int index, FeatureMap.Entry object) {
            CDOObjectImpl.this.getStore().add(this.owner, this.eStructuralFeature, index, object);
        }

        protected void delegateAdd(FeatureMap.Entry object) {
            this.delegateAdd(this.delegateSize(), object);
        }

        protected List<FeatureMap.Entry> delegateBasicList() {
            int size = this.delegateSize();
            if (size == 0) {
                return (List)ECollections.emptyEList();
            }
            Object[] data = CDOObjectImpl.this.getStore().toArray(this.owner, this.eStructuralFeature);
            return new EcoreEList.UnmodifiableEList(this.owner, this.eStructuralFeature, data.length, data);
        }

        protected void delegateClear() {
            CDOObjectImpl.this.getStore().clear(this.owner, this.eStructuralFeature);
        }

        protected boolean delegateContains(Object object) {
            return CDOObjectImpl.this.getStore().contains(this.owner, this.eStructuralFeature, object);
        }

        protected boolean delegateContainsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.delegateContains(o)) continue;
                return false;
            }
            return true;
        }

        protected FeatureMap.Entry delegateGet(int index) {
            return (FeatureMap.Entry)CDOObjectImpl.this.getStore().get(this.owner, this.eStructuralFeature, index);
        }

        protected int delegateHashCode() {
            return CDOObjectImpl.this.getStore().hashCode(this.owner, this.eStructuralFeature);
        }

        protected int delegateIndexOf(Object object) {
            return CDOObjectImpl.this.getStore().indexOf(this.owner, this.eStructuralFeature, object);
        }

        protected boolean delegateIsEmpty() {
            return CDOObjectImpl.this.getStore().isEmpty(this.owner, this.eStructuralFeature);
        }

        protected Iterator<FeatureMap.Entry> delegateIterator() {
            return this.iterator();
        }

        protected int delegateLastIndexOf(Object object) {
            return CDOObjectImpl.this.getStore().lastIndexOf(this.owner, this.eStructuralFeature, object);
        }

        protected ListIterator<FeatureMap.Entry> delegateListIterator() {
            return this.listIterator();
        }

        protected FeatureMap.Entry delegateRemove(int index) {
            return (FeatureMap.Entry)CDOObjectImpl.this.getStore().remove(this.owner, this.eStructuralFeature, index);
        }

        protected FeatureMap.Entry delegateSet(int index, FeatureMap.Entry object) {
            return (FeatureMap.Entry)CDOObjectImpl.this.getStore().set(this.owner, this.eStructuralFeature, index, object);
        }

        protected int delegateSize() {
            return CDOObjectImpl.this.getStore().size(this.owner, this.eStructuralFeature);
        }

        protected Object[] delegateToArray() {
            return CDOObjectImpl.this.getStore().toArray(this.owner, this.eStructuralFeature);
        }

        protected <T> T[] delegateToArray(T[] array) {
            return CDOObjectImpl.this.getStore().toArray(this.owner, this.eStructuralFeature, array);
        }

        protected FeatureMap.Entry delegateMove(int targetIndex, int sourceIndex) {
            return (FeatureMap.Entry)CDOObjectImpl.this.getStore().move(this.owner, this.eStructuralFeature, targetIndex, sourceIndex);
        }

        protected String delegateToString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            int i = 0;
            int size = this.size();
            while (i < size) {
                FeatureMap.Entry value = this.delegateGet(i);
                stringBuffer.append(String.valueOf(value));
                if (++i >= size) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

