/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.analyzer.CDOFetchRuleManager;
import org.eclipse.emf.cdo.common.analyzer.CDOFetchRule;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.internal.cdo.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOSessionPackageManagerImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CDOClientRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionRequest
extends CDOClientRequest<List<InternalCDORevision>> {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionRequest.class);
    private Collection<CDOID> ids;
    private int referenceChunk;

    public LoadRevisionRequest(IChannel channel, Collection<CDOID> ids, int referenceChunk) {
        super(channel);
        this.ids = ids;
        this.referenceChunk = referenceChunk;
    }

    protected short getSignalID() {
        return 7;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
        out.writeInt(this.referenceChunk);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} IDs", new Object[]{this.ids.size()});
        }
        out.writeInt(this.ids.size());
        for (CDOID id : this.ids) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing ID: {0}", new Object[]{id});
            }
            CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)id);
        }
        CDOFetchRuleManager ruleManager = this.getSession().getRevisionManager().getRuleManager();
        List<CDOFetchRule> fetchRules = ruleManager.getFetchRules(this.ids);
        if (fetchRules == null || fetchRules.size() <= 0) {
            out.writeInt(0);
        } else {
            int fetchSize = fetchRules.size();
            CDOID contextID = ruleManager.getContext();
            out.writeInt(fetchSize);
            out.writeInt(ruleManager.getLoadRevisionCollectionChunkSize());
            CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)contextID);
            for (CDOFetchRule fetchRule : fetchRules) {
                fetchRule.write((ExtendedDataOutput)out);
            }
        }
    }

    protected List<InternalCDORevision> confirming(ExtendedDataInputStream in) throws IOException {
        CDOSessionImpl session = this.getSession();
        CDORevisionManagerImpl revisionManager = session.getRevisionManager();
        CDOSessionPackageManagerImpl packageManager = session.getPackageManager();
        ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>(this.ids.size());
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} revisions", new Object[]{this.ids.size()});
        }
        int i = 0;
        while (i < this.ids.size()) {
            InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.read((ExtendedDataInput)in, (CDORevisionResolver)revisionManager, (CDOPackageManager)packageManager);
            revisions.add(revision);
            ++i;
        }
        int size = in.readInt();
        if (size != 0) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Reading {0} additional revisions", new Object[]{size});
            }
            int i2 = 0;
            while (i2 < size) {
                InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.read((ExtendedDataInput)in, (CDORevisionResolver)revisionManager, (CDOPackageManager)packageManager);
                revisionManager.addRevision(revision);
                ++i2;
            }
        }
        return revisions;
    }

    public Collection<CDOID> getIds() {
        return this.ids;
    }

    public int getReferenceChunk() {
        return this.referenceChunk;
    }

    public String toString() {
        return MessageFormat.format("{0}(ids={1}, referenceChunk={2})", ((Object)((Object)this)).getClass().getSimpleName(), this.ids, this.referenceChunk);
    }
}

