/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.concurrent.RWLockManager;

public class UnlockObjectsIndication
extends CDOReadIndication {
    public UnlockObjectsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)26);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        RWLockManager.LockType lockType = in.readCDOLockType();
        int size = in.readInt();
        IView view = this.getSession().getView(viewID);
        if (size == -1) {
            this.getRepository().getLockManager().unlock(view);
        } else {
            ArrayList<CDOID> ids = new ArrayList<CDOID>(size);
            int i = 0;
            while (i < size) {
                CDOID id = in.readCDOID();
                ids.add(id);
                ++i;
            }
            this.getRepository().getLockManager().unlock(lockType, view, ids);
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeBoolean(true);
    }
}

