/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.TestsPlugin;
import org.junit.Assert;

public class PrivilegedRunnableTest
extends AbstractTest {
    static final IStatus TEST_STATUS = new Status(0, TestsPlugin.instance.getBundle().getSymbolicName(), 0, "OK", null);
    private TestThread thread;
    private TestThread thread2;
    private TestRead read;
    private TestReadWithResult readWithResult;
    private TestWrite write;
    private TestWriteWithResult writeWithResult;

    public PrivilegedRunnableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PrivilegedRunnableTest.class, "Privileged Runnable Tests");
    }

    public void test_sharingReadOnlyTransaction() {
        this.startReading();
        RunnableWithResult privileged = this.domain.createPrivilegedRunnable((Runnable)this.read);
        this.thread.syncExec((Runnable)privileged);
        PrivilegedRunnableTest.assertTrue((boolean)this.read.wasExecuted);
        PrivilegedRunnableTest.assertTrue((boolean)privileged.getStatus().isOK());
        this.commit();
        this.startReading();
        privileged = this.domain.createPrivilegedRunnable((Runnable)((Object)this.readWithResult));
        this.thread.syncExec((Runnable)privileged);
        PrivilegedRunnableTest.assertTrue((boolean)this.readWithResult.wasExecuted);
        PrivilegedRunnableTest.assertSame((Object)TEST_STATUS, (Object)this.readWithResult.getStatus());
        PrivilegedRunnableTest.assertEquals((Object)this.root.getBooks(), (Object)this.readWithResult.getResult());
        PrivilegedRunnableTest.assertSame((Object)this.readWithResult.getStatus(), (Object)privileged.getStatus());
        PrivilegedRunnableTest.assertSame((Object)this.readWithResult.getResult(), (Object)privileged.getResult());
        this.commit();
    }

    public void test_sharingReadWriteTransaction() {
        this.startWriting();
        RunnableWithResult privileged = this.domain.createPrivilegedRunnable((Runnable)this.write);
        this.thread.syncExec((Runnable)privileged);
        PrivilegedRunnableTest.assertTrue((boolean)this.write.wasExecuted);
        PrivilegedRunnableTest.assertTrue((boolean)privileged.getStatus().isOK());
        PrivilegedRunnableTest.assertTrue((boolean)this.root.getBooks().isEmpty());
        this.rollback();
        this.startWriting();
        PrivilegedRunnableTest.assertFalse((boolean)this.root.getBooks().isEmpty());
        privileged = this.domain.createPrivilegedRunnable((Runnable)((Object)this.writeWithResult));
        this.thread.syncExec((Runnable)privileged);
        PrivilegedRunnableTest.assertTrue((boolean)this.writeWithResult.wasExecuted);
        PrivilegedRunnableTest.assertSame((Object)TEST_STATUS, (Object)this.writeWithResult.getStatus());
        PrivilegedRunnableTest.assertEquals((Object)this.root.getBooks(), (Object)this.writeWithResult.getResult());
        PrivilegedRunnableTest.assertSame((Object)this.writeWithResult.getStatus(), (Object)privileged.getStatus());
        PrivilegedRunnableTest.assertSame((Object)this.writeWithResult.getResult(), (Object)privileged.getResult());
        PrivilegedRunnableTest.assertTrue((boolean)this.root.getBooks().isEmpty());
        this.root.getWriters().clear();
        this.rollback();
    }

    public void test_nestedSharing() {
        this.thread2 = new TestThread();
        this.thread2.start();
        Runnable nestingRunnable = new Runnable(){

            @Override
            public void run() {
                PrivilegedRunnableTest.this.thread2.syncExec((Runnable)PrivilegedRunnableTest.this.domain.createPrivilegedRunnable((Runnable)PrivilegedRunnableTest.this.write));
            }
        };
        this.startWriting();
        RunnableWithResult privileged = this.domain.createPrivilegedRunnable(nestingRunnable);
        this.thread.syncExec((Runnable)privileged);
        PrivilegedRunnableTest.assertTrue((boolean)this.write.wasExecuted);
        PrivilegedRunnableTest.assertTrue((boolean)privileged.getStatus().isOK());
        PrivilegedRunnableTest.assertTrue((boolean)this.root.getBooks().isEmpty());
        this.rollback();
    }

    public void test_transactionMustBeActive() {
        this.startWriting();
        RunnableWithResult privileged = this.domain.createPrivilegedRunnable((Runnable)this.write);
        this.commit();
        this.thread.syncExec((Runnable)privileged);
        Exception e = this.thread.getException();
        PrivilegedRunnableTest.assertNotNull((String)"Should have thrown IllegalStateException", (Object)e);
        System.out.println("Got expected exception: " + e.getLocalizedMessage());
    }

    public void test_transactionMustBeCurrent() {
        this.startWriting();
        RunnableWithResult privileged = this.domain.createPrivilegedRunnable((Runnable)this.write);
        this.startWriting();
        this.thread.syncExec((Runnable)privileged);
        Exception e = this.thread.getException();
        PrivilegedRunnableTest.assertNotNull((String)"Should have thrown IllegalStateException", (Object)e);
        System.out.println("Got expected exception: " + e.getLocalizedMessage());
        this.commit();
        this.commit();
    }

    public void test_runtimeExceptionInRunnable_146625() {
        final RuntimeException e = new RuntimeException();
        this.startReading();
        RunnableWithResult privileged = this.domain.createPrivilegedRunnable(new Runnable(){

            @Override
            public void run() {
                throw e;
            }
        });
        this.thread.syncExec((Runnable)privileged);
        PrivilegedRunnableTest.assertNotNull((Object)privileged.getStatus());
        PrivilegedRunnableTest.assertFalse((boolean)privileged.getStatus().isOK());
        PrivilegedRunnableTest.assertSame((Object)e, (Object)privileged.getStatus().getException());
        this.commit();
    }

    public void test_concurrentAcquireDuringPrivilegedRunnable_162027() throws Exception {
        final Object handshake = new Object();
        final Exception[] shouldNotBeThrown = new Exception[1];
        this.startReading();
        Thread otherThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = handshake;
                synchronized (object) {
                    try {
                        handshake.wait();
                    }
                    catch (InterruptedException e) {
                        PrivilegedRunnableTest.fail((String)"Interrupted");
                    }
                    handshake.notifyAll();
                }
                try {
                    PrivilegedRunnableTest.this.domain.runExclusive(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                PrivilegedRunnableTest.fail((String)"Interrupted");
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    PrivilegedRunnableTest.fail((String)"Interrupted");
                }
                catch (IllegalArgumentException e) {
                    shouldNotBeThrown[0] = e;
                }
            }
        });
        otherThread.setDaemon(true);
        otherThread.start();
        Thread.sleep(500L);
        RunnableWithResult privileged = this.domain.createPrivilegedRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = handshake;
                synchronized (object) {
                    handshake.notifyAll();
                    try {
                        handshake.wait();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        PrivilegedRunnableTest.fail((String)"Interrupted");
                    }
                }
            }
        });
        this.thread.syncExec((Runnable)privileged);
        this.commit();
        Thread.sleep(2000L);
        PrivilegedRunnableTest.assertNull((Object)shouldNotBeThrown[0]);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.thread = new TestThread();
        this.thread.start();
        this.read = new TestRead();
        this.readWithResult = new TestReadWithResult();
        this.write = new TestWrite();
        this.writeWithResult = new TestWriteWithResult();
    }

    @Override
    protected void doTearDown() throws Exception {
        this.read = null;
        this.readWithResult = null;
        this.write = null;
        this.writeWithResult = null;
        this.thread.die();
        this.thread = null;
        if (this.thread2 != null) {
            this.thread2.die();
            this.thread2 = null;
        }
        super.doTearDown();
    }

    class TestRead
    implements Runnable {
        boolean wasExecuted = false;

        TestRead() {
        }

        @Override
        public void run() {
            PrivilegedRunnableTest.this.root.getBooks();
            this.wasExecuted = true;
        }
    }

    class TestReadWithResult
    extends RunnableWithResult.Impl<List<Book>> {
        boolean wasExecuted = false;

        TestReadWithResult() {
        }

        public void run() {
            this.setResult(PrivilegedRunnableTest.this.root.getBooks());
            this.setStatus(TEST_STATUS);
            this.wasExecuted = true;
        }
    }

    class TestThread
    extends Thread {
        private boolean shouldDie;
        private Runnable runnable;
        private Exception exception;

        TestThread() {
            super("Privilege Test thread");
            this.shouldDie = false;
            this.exception = null;
            this.setDaemon(true);
        }

        public synchronized void die() {
            this.shouldDie = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void syncExec(Runnable runnable) {
            TestThread testThread = this;
            synchronized (testThread) {
                this.runnable = runnable;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Interrupted while waiting for runnable");
                }
            }
        }

        public Exception getException() {
            Exception result = this.exception;
            this.exception = null;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                TestThread testThread = this;
                synchronized (testThread) {
                    if (this.shouldDie) {
                        this.notifyAll();
                        break;
                    }
                    if (this.runnable != null) {
                        this.execute(this.runnable);
                        this.runnable = null;
                        this.notifyAll();
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void execute(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }

    class TestWrite
    implements Runnable {
        boolean wasExecuted = false;

        TestWrite() {
        }

        @Override
        public void run() {
            PrivilegedRunnableTest.this.root.getBooks().clear();
            this.wasExecuted = true;
        }
    }

    class TestWriteWithResult
    extends RunnableWithResult.Impl<List<Book>> {
        boolean wasExecuted = false;

        TestWriteWithResult() {
        }

        public void run() {
            PrivilegedRunnableTest.this.root.getBooks().clear();
            this.setResult(PrivilegedRunnableTest.this.root.getBooks());
            this.setStatus(TEST_STATUS);
            this.wasExecuted = true;
        }
    }
}

