/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;

public class JobManagerSuspensionDeadlockTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(JobManagerSuspensionDeadlockTest.class, "JobManager Suspension Dead-lock Tests");
    }

    public void testDeadlock() throws Exception {
        TransactionalEditingDomainImpl domain = new TransactionalEditingDomainImpl((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        final Object lock = new Object();
        Thread t1 = new Thread("Thread-1", (TransactionalEditingDomain)domain){
            private final /* synthetic */ TransactionalEditingDomain val$domain;
            {
                this.val$domain = transactionalEditingDomain;
                super($anonymous0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    System.out.println("Thread-1: Started");
                    Object object = lock;
                    synchronized (object) {
                        lock.wait();
                    }
                    System.out.println("Thread-1: Invoke runExclusive");
                    this.val$domain.runExclusive(new Runnable(){

                        @Override
                        public void run() {
                            System.out.println("Thread-1: Do something Do something in exclusive mode");
                        }
                    });
                    System.out.println("Thread-1: Finished");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t2 = new Thread("Thread-2", (TransactionalEditingDomain)domain, lock){
            private final /* synthetic */ TransactionalEditingDomain val$domain;
            private final /* synthetic */ Object val$lock;
            {
                this.val$domain = transactionalEditingDomain;
                this.val$lock = object;
                super($anonymous0);
            }

            @Override
            public void run() {
                System.out.println("Thread-2: Started");
                try {
                    System.out.println("Thread-2: Invoke runExclusive");
                    this.val$domain.runExclusive(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = val$lock;
                            synchronized (object) {
                                val$lock.notifyAll();
                            }
                            System.out.println("Thread-2: Do something in exclusive mode for 1 second");
                            try {
                                2.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Thread-2: Finished");
            }
        };
        try {
            Job.getJobManager().suspend();
            t1.start();
            t1.join(250L);
            JobManagerSuspensionDeadlockTest.assertTrue((boolean)t1.isAlive());
            t2.start();
            t2.join(5000L);
            JobManagerSuspensionDeadlockTest.assertFalse((boolean)t2.isAlive());
            t1.join(5000L);
            JobManagerSuspensionDeadlockTest.assertFalse((boolean)t1.isAlive());
        }
        finally {
            Job.getJobManager().resume();
        }
    }
}

