/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.teneo.ERuntime;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.mapping.econtainer.NewEContainerFeatureIDPropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheHandler;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierPropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierUtil;
import org.eclipse.emf.teneo.hibernate.mapping.property.EAttributePropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.property.EReferencePropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.property.SyntheticPropertyHandler;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.EmbeddedPropertyAccessor;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbUtil {
    private static Log log = LogFactory.getLog(HbUtil.class);

    public static EClass getEClassFromMeta(Component component) {
        MetaAttribute ePackageMetaAttribute = component.getMetaAttribute("epackage");
        if (ePackageMetaAttribute == null) {
            return null;
        }
        EPackage epackage = PackageRegistryProvider.getInstance().getPackageRegistry().getEPackage(ePackageMetaAttribute.getValue());
        if (epackage == null) {
            throw new IllegalArgumentException("Could not find ePackage using nsuri " + ePackageMetaAttribute.getValue());
        }
        MetaAttribute eClassMetaAttribute = component.getMetaAttribute("eclassName");
        if (eClassMetaAttribute == null) {
            return null;
        }
        return (EClass)epackage.getEClassifier(eClassMetaAttribute.getValue());
    }

    public static EObject merge(Session session, EObject eObject, int maxMergeLevel) {
        SessionImplementor sessionImplementor = (SessionImplementor)session;
        return HbUtil.merge(sessionImplementor, eObject, new HashMap<EObject, EObject>(), maxMergeLevel, 0);
    }

    private static EObject merge(SessionImplementor sessionImplementor, EObject eObject, Map<EObject, EObject> copyCache, int maxMergeLevel, int currentMergeLevel) {
        if (copyCache.containsKey(eObject)) {
            return copyCache.get(eObject);
        }
        String entityName = sessionImplementor.guessEntityName((Object)eObject);
        EntityPersister persister = sessionImplementor.getEntityPersister(entityName, (Object)eObject);
        Serializable id = persister.getIdentifier((Object)eObject, sessionImplementor);
        if (id != null) {
            EObject source = (EObject)((Session)sessionImplementor).get(entityName, id);
            copyCache.put(eObject, source);
            if (maxMergeLevel == currentMergeLevel) {
                return source;
            }
            for (EStructuralFeature eFeature : source.eClass().getEAllStructuralFeatures()) {
                if (eFeature instanceof EAttribute) {
                    source.eSet(eFeature, eObject.eGet(eFeature));
                    continue;
                }
                if (eFeature.isMany()) {
                    ArrayList<EObject> newValues = new ArrayList<EObject>();
                    List currentValues = (List)eObject.eGet(eFeature);
                    for (EObject currentValue : currentValues) {
                        newValues.add(HbUtil.merge(sessionImplementor, currentValue, copyCache, maxMergeLevel, currentMergeLevel + 1));
                    }
                    source.eSet(eFeature, newValues);
                    continue;
                }
                source.eSet(eFeature, (Object)HbUtil.merge(sessionImplementor, (EObject)eObject.eGet(eFeature), copyCache, maxMergeLevel, currentMergeLevel + 1));
            }
            return source;
        }
        return eObject;
    }

    public static boolean isEAVMapped(PersistentClass mappedEntity) {
        if (mappedEntity.getEntityName() != null && mappedEntity.getEntityName().equals("EAV_EObject")) {
            return true;
        }
        if (mappedEntity.getSuperclass() == null) {
            return false;
        }
        return HbUtil.isEAVMapped(mappedEntity.getSuperclass());
    }

    public static String idToString(EObject eobj, HbDataStore hd) {
        PersistentClass pc = hd.getPersistentClass(hd.getEntityNameStrategy().toEntityName(eobj.eClass()));
        if (pc == null) {
            return null;
        }
        Object id = eobj instanceof HibernateProxy ? ((HibernateProxy)eobj).getHibernateLazyInitializer().getIdentifier() : IdentifierUtil.getID(eobj, hd);
        if (id == null && (id = IdentifierCacheHandler.getInstance().getID(eobj)) == null) {
            return null;
        }
        Type t = pc.getIdentifierProperty().getType();
        if (t instanceof PrimitiveType) {
            return ((PrimitiveType)t).toString(id);
        }
        if (t instanceof StringType) {
            return (String)id;
        }
        return null;
    }

    public static Object stringToId(EClass eclass, HbDataStore hd, String id) {
        try {
            PersistentClass pc = hd.getPersistentClass(hd.getEntityNameStrategy().toEntityName(eclass));
            Type t = pc.getIdentifierProperty().getType();
            if (t instanceof IdentifierType) {
                return ((IdentifierType)t).stringToObject(id);
            }
            if (t instanceof StringType) {
                return id;
            }
            return null;
        }
        catch (Exception e) {
            throw new HbStoreException("Exception while converting id: " + id + " of eclass " + eclass.getName());
        }
    }

    public static PropertyAccessor getPropertyAccessor(Property mappedProperty, HbDataStore ds, String entityName, EClass mappedEClass) {
        boolean extraLazy;
        if (mappedProperty.getMetaAttribute("synthetic-property") != null) {
            return new SyntheticPropertyHandler(mappedProperty.getName());
        }
        if (mappedProperty.getMetaAttribute("syntheticId") != null) {
            return new IdentifierPropertyHandler();
        }
        if (mappedProperty.getMetaAttribute("syntheticVersion") != null) {
            return ds.getHbContext().createVersionAccessor();
        }
        if (mappedProperty.getName().compareToIgnoreCase("_identifierMapper") == 0) {
            return new EmbeddedPropertyAccessor();
        }
        if (mappedProperty.getName().compareToIgnoreCase("e_container") == 0) {
            return ds.getHbContext().createEContainerAccessor();
        }
        if (mappedProperty.getName().compareToIgnoreCase("e_container_featurename") == 0) {
            return (PropertyAccessor)ds.getExtensionManager().getExtension(NewEContainerFeatureIDPropertyHandler.class);
        }
        if (mappedProperty.getName().compareToIgnoreCase("e_container_featureid") == 0) {
            return ds.getHbContext().createEContainerFeatureIDAccessor();
        }
        EClass eClass = null;
        if (mappedEClass != null) {
            eClass = mappedEClass;
        } else {
            eClass = ds.getEntityNameStrategy().toEClass(entityName);
            if (eClass == null) {
                eClass = ERuntime.INSTANCE.getEClass(entityName);
            }
        }
        EStructuralFeature efeature = StoreUtil.getEStructuralFeature((EClass)eClass, (String)mappedProperty.getName());
        if (efeature == null) {
            throw new HbMapperException("Feature not found for eclass/entity/property " + eClass.getName() + "/" + entityName + "/" + mappedProperty.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating property accessor for " + mappedProperty.getName() + "/" + entityName + "/" + efeature.getName()));
        }
        boolean bl = extraLazy = mappedProperty.getValue() instanceof Collection && ((Collection)mappedProperty.getValue()).isExtraLazy();
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)efeature)) {
            return ds.getHbContext().createFeatureMapPropertyAccessor(efeature);
        }
        if (efeature instanceof EReference) {
            EReference eref = (EReference)efeature;
            if (eref.isMany()) {
                return ds.getHbContext().createEListAccessor(efeature, extraLazy, ds.getPersistenceOptions().isMapEMapAsTrueMap());
            }
            PropertyAccessor erefPropertyHandler = ds.getHbContext().createEReferenceAccessor(eref);
            if (erefPropertyHandler instanceof EReferencePropertyHandler && mappedProperty.getPersistentClass() != null) {
                ((EReferencePropertyHandler)erefPropertyHandler).setId(mappedProperty == mappedProperty.getPersistentClass().getIdentifierProperty());
            }
            return erefPropertyHandler;
        }
        EAttribute eattr = (EAttribute)efeature;
        if (eattr.isMany()) {
            return ds.getHbContext().createEListAccessor(efeature, extraLazy, ds.getPersistenceOptions().isMapEMapAsTrueMap());
        }
        PropertyAccessor pa = ds.getHbContext().createEAttributeAccessor(eattr);
        if (pa instanceof EAttributePropertyHandler) {
            EAttributePropertyHandler eAttributePropertyHandler = (EAttributePropertyHandler)pa;
            eAttributePropertyHandler.setPersistenceOptions(ds.getPersistenceOptions());
            if (mappedProperty.getPersistentClass() != null) {
                eAttributePropertyHandler.setId(mappedProperty == mappedProperty.getPersistentClass().getIdentifierProperty());
            }
        }
        return pa;
    }

    public static String getEClassNameFromFeatureMapMeta(PersistentClass pc) {
        MetaAttribute ma = pc.getMetaAttribute("featureMap");
        if (ma == null) {
            return null;
        }
        return ma.getValue();
    }

    public static HbDataStore getCreateDataStore(Properties props) {
        String name = props.getProperty("name");
        HbDataStore eds = HbHelper.INSTANCE.getDataStore(name);
        if (eds != null) {
            return eds;
        }
        Properties hbProps = new Properties();
        hbProps.putAll((Map<?, ?>)props);
        hbProps.put("hibernate.connection.username", HbUtil.doTrim(props.getProperty("dbuser")));
        hbProps.put("hibernate.connection.password", HbUtil.doTrim(props.getProperty("dbpassword")));
        hbProps.put("hibernate.connection.driver_class", HbUtil.doTrim(props.getProperty("dbdriver")));
        hbProps.put("hibernate.connection.url", HbUtil.doTrim(props.getProperty("dburl")));
        hbProps.put("hibernate.dialect", HbUtil.doTrim(props.getProperty("dbdialect")));
        EPackage[] epacks = StoreUtil.getEPackages((String)HbUtil.doTrim(props.getProperty("nsuri")));
        eds = HbHelper.INSTANCE.createRegisterDataStore(name);
        eds.setDataStoreProperties(hbProps);
        eds.setEPackages(epacks);
        eds.initialize();
        return eds;
    }

    private static String doTrim(String totrim) {
        if (totrim == null) {
            return null;
        }
        return totrim.trim();
    }
}

