/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.DiscriminatorColumn;
import org.eclipse.emf.teneo.annotations.pannotation.DiscriminatorType;
import org.eclipse.emf.teneo.annotations.pannotation.DiscriminatorValue;
import org.eclipse.emf.teneo.annotations.pannotation.InheritanceType;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationFactory;
import org.eclipse.emf.teneo.annotations.pannotation.PrimaryKeyJoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.SecondaryTable;
import org.eclipse.emf.teneo.annotations.pannotation.Table;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.DiscriminatorFormula;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbEntity;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEClass;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractMapper;
import org.eclipse.emf.teneo.hibernate.mapper.FeatureMapMapping;
import org.eclipse.emf.teneo.hibernate.mapper.IdMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.simpledom.DocumentHelper;
import org.eclipse.emf.teneo.simpledom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMapper
extends AbstractMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(EntityMapper.class);
    private static final String[] INHERITANCE_STRATEGY_NAMES = new String[InheritanceType.VALUES.size()];
    private static final String[] DISCRIMINATOR_TYPE_NAMES;
    private final String PRIMARY_TABLE_KEY;

    static {
        EntityMapper.INHERITANCE_STRATEGY_NAMES[InheritanceType.JOINED.getValue()] = "joined-subclass";
        EntityMapper.INHERITANCE_STRATEGY_NAMES[InheritanceType.SINGLE_TABLE.getValue()] = "subclass";
        EntityMapper.INHERITANCE_STRATEGY_NAMES[InheritanceType.TABLE_PER_CLASS.getValue()] = "union-subclass";
        DISCRIMINATOR_TYPE_NAMES = new String[DiscriminatorType.VALUES.size()];
        EntityMapper.DISCRIMINATOR_TYPE_NAMES[DiscriminatorType.CHAR.getValue()] = "character";
        EntityMapper.DISCRIMINATOR_TYPE_NAMES[DiscriminatorType.INTEGER.getValue()] = "integer";
        EntityMapper.DISCRIMINATOR_TYPE_NAMES[DiscriminatorType.STRING.getValue()] = "string";
    }

    public EntityMapper() {
        this.PRIMARY_TABLE_KEY = null;
    }

    private static String hbInheritanceName(InheritanceType inheritanceType) {
        return INHERITANCE_STRATEGY_NAMES[inheritanceType != null ? inheritanceType.getValue() : InheritanceType.SINGLE_TABLE.getValue()];
    }

    private static String hbDiscriminatorType(DiscriminatorType dType) {
        return DISCRIMINATOR_TYPE_NAMES[dType == null ? DiscriminatorType.STRING.getValue() : dType.getValue()];
    }

    private Element createEntity(PAnnotatedEClass entity, InheritanceType inhStrategy, PAnnotatedEClass superEntity, DiscriminatorValue dValue, Table table) {
        String proxyInterfaceName;
        Element target;
        boolean doProxy;
        InheritanceType inheritanceStrategy = inhStrategy != null ? inhStrategy : InheritanceType.SINGLE_TABLE;
        EClass eclass = entity.getModelEClass();
        String hbClassName = entity.getEavMapping() != null ? EntityMapper.hbInheritanceName(InheritanceType.SINGLE_TABLE) : (superEntity == null ? "class" : EntityMapper.hbInheritanceName(inheritanceStrategy));
        log.debug((Object)("Creating entity tag " + hbClassName));
        String entityName = this.getHbmContext().getEntityName(eclass);
        String isAbstractStr = eclass.isAbstract() ? "true" : "false";
        boolean bl = doProxy = ((HbAnnotatedEClass)entity).getHbProxy() != null && ((HbAnnotatedEClass)entity).getHbProxy().isLazy();
        if (entity.isOnlyMapAsEntity()) {
            target = this.getHbmContext().getCurrent().addElement(hbClassName).addAttribute("entity-name", entityName).addAttribute("abstract", isAbstractStr).addAttribute("lazy", "false");
            if (this.hasCompositeID(entity)) {
                target.addAttribute("name", this.hbmContext.getInstanceClassName(entity.getModelEClass()));
            }
        } else if (this.getHbmContext().forceUseOfInstance(entity)) {
            Element importElement = new Element("import");
            importElement.addAttribute("class", this.hbmContext.getInstanceClassName(entity.getModelEClass())).addAttribute("rename", entityName);
            this.getHbmContext().getCurrent().add(this.getImportIndex(), importElement);
            target = this.getHbmContext().getCurrent().addElement(hbClassName).addAttribute("name", this.hbmContext.getInstanceClassName(entity.getModelEClass())).addAttribute("abstract", isAbstractStr).addAttribute("lazy", doProxy ? "true" : "false");
        } else {
            target = this.getHbmContext().getInstanceClass((EClassifier)entity.getModelEClass()) == null ? this.getHbmContext().getCurrent().addElement(hbClassName).addAttribute("entity-name", entityName).addAttribute("abstract", isAbstractStr).addAttribute("lazy", doProxy ? "true" : "false") : this.getHbmContext().getCurrent().addElement(hbClassName).addAttribute("name", this.hbmContext.getInstanceClassName(entity.getModelEClass())).addAttribute("entity-name", entityName).addAttribute("abstract", isAbstractStr).addAttribute("lazy", doProxy ? "true" : "false");
        }
        HbAnnotatedEClass hbEntity = (HbAnnotatedEClass)entity;
        if (superEntity == null && hbEntity.getImmutable() != null) {
            target.addAttribute("mutable", "false");
        }
        if (hbEntity.getBatchSize() != null) {
            target.addAttribute("batch-size", "" + hbEntity.getBatchSize().getSize());
        }
        if (hbEntity.getHbEntity() != null) {
            HbEntity hbEntityAnnon = hbEntity.getHbEntity();
            if (superEntity == null) {
                if (!hbEntityAnnon.isMutable() && target.getAttributeValue("mutable") == null) {
                    target.addAttribute("mutable", "false");
                }
                if (hbEntityAnnon.getPolymorphism() != null) {
                    target.addAttribute("polymorphism", hbEntityAnnon.getPolymorphism().getName().toLowerCase());
                }
                if (hbEntityAnnon.getOptimisticLock() != null) {
                    target.addAttribute("optimistic-lock", hbEntityAnnon.getOptimisticLock().getName().toLowerCase());
                }
            }
            if (hbEntityAnnon.isDynamicInsert()) {
                target.addAttribute("dynamic-insert", "true");
            }
            if (hbEntityAnnon.isDynamicUpdate()) {
                target.addAttribute("dynamic-update", "true");
            }
            if (hbEntityAnnon.isSelectBeforeUpdate()) {
                target.addAttribute("select-before-update", "true");
            }
            if (hbEntityAnnon.getPersister() != null) {
                target.addAttribute("persister", hbEntityAnnon.getPersister());
            }
        }
        if (superEntity != null) {
            String extendsEntity = superEntity.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(superEntity) ? this.getHbmContext().getEntityName(superEntity.getModelEClass()) : this.getHbmContext().getInstanceClassName(superEntity.getModelEClass());
            target.addAttribute("extends", extendsEntity);
            log.debug((Object)("Extends " + extendsEntity));
        }
        if (entity.getEavMapping() != null) {
            if (superEntity == null) {
                target.addAttribute("extends", "EAV_EObject");
            }
            target.addAttribute("discriminator-value", dValue.getValue());
            if (((HbAnnotatedEClass)entity).getHbProxy() != null && ((HbAnnotatedEClass)entity).getHbProxy().getProxyClass() != null) {
                proxyInterfaceName = ((HbAnnotatedEClass)entity).getHbProxy().getProxyClass();
                target.addAttribute("proxy", proxyInterfaceName);
            }
            return target;
        }
        if (dValue != null && !target.getName().equals(INHERITANCE_STRATEGY_NAMES[InheritanceType.JOINED.getValue()]) && !target.getName().equals(InheritanceType.TABLE_PER_CLASS.getValue())) {
            target.addAttribute("discriminator-value", dValue.getValue());
            log.debug((Object)("DValue " + dValue.getValue()));
        }
        if (table != null && hbClassName.compareTo(INHERITANCE_STRATEGY_NAMES[InheritanceType.SINGLE_TABLE.getValue()]) == 0) {
            log.warn((Object)("EClass/Entity (" + entityName + ") is mapped as subclass in a single table with its superclass but it also has a table annotation. This table annotation is ignored."));
        } else if (table != null) {
            if (table.getName() != null) {
                target.addAttribute("table", this.getHbmContext().trunc(table.getName(), false));
                log.debug((Object)("Table " + table.getName()));
            }
            if (table.getSchema() != null) {
                target.addAttribute("schema", this.getHbmContext().trunc(table.getSchema(), false));
                log.debug((Object)("Schema " + table.getSchema()));
            }
            if (table.getCatalog() != null) {
                target.addAttribute("catalog", this.getHbmContext().trunc(table.getCatalog(), false));
                log.debug((Object)("Catalog " + table.getCatalog()));
            }
        }
        if (((HbAnnotatedEClass)entity).getHbWhere() != null) {
            target.addAttribute("where", ((HbAnnotatedEClass)entity).getHbWhere().getClause());
        }
        if (((HbAnnotatedEClass)entity).getHbProxy() != null && ((HbAnnotatedEClass)entity).getHbProxy().getProxyClass() != null) {
            proxyInterfaceName = ((HbAnnotatedEClass)entity).getHbProxy().getProxyClass();
            target.addAttribute("proxy", proxyInterfaceName);
        }
        return target;
    }

    protected int getImportIndex() {
        List children = this.getHbmContext().getCurrent().getChildren();
        int defaultResult = 0;
        int i = 0;
        while (i < children.size()) {
            Element e = (Element)children.get(i);
            String name = e.getName();
            if (name.compareTo("class") == 0 || name.compareTo("subclass") == 0 || name.compareTo("joined-subclass") == 0 || name.compareTo("union-subclass") == 0) {
                return i;
            }
            if (name.compareTo("typedef") == 0 || name.compareTo("meta") == 0) {
                defaultResult = i + 1;
            }
            ++i;
        }
        return defaultResult;
    }

    private boolean hasCompositeID(PAnnotatedEClass aClass) {
        if (aClass.getIdClass() != null) {
            return true;
        }
        if (aClass.getPaSuperEntity() != null) {
            return this.hasCompositeID(aClass.getPaSuperEntity());
        }
        for (PAnnotatedEClass superAClass : aClass.getPaMappedSupers()) {
            if (!this.hasCompositeID(superAClass)) continue;
            return true;
        }
        EList features = aClass.getPaEStructuralFeatures();
        for (PAnnotatedEStructuralFeature feature : features) {
            if (!(feature instanceof PAnnotatedEReference) || ((PAnnotatedEReference)feature).getEmbeddedId() == null) continue;
            return true;
        }
        return false;
    }

    public void processEntity(PAnnotatedEClass entity) {
        int index;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping Entity " + entity));
        }
        HbAnnotatedEClass hbEntity = (HbAnnotatedEClass)entity;
        Element entityElement = this.createEntity(entity, entity.getInheritanceStrategy(), entity.getPaSuperEntity(), entity.getDiscriminatorValue(), entity.getTable());
        if (entity.getEavMapping() != null) {
            return;
        }
        MappingContext mc = this.getHbmContext();
        mc.setCurrent(entityElement);
        mc.setCurrentTable(entity.getTable());
        if (entity.getPaSuperEntity() == null && entity.getPrimaryKeyJoinColumns() != null && entity.getPrimaryKeyJoinColumns().size() > 0) {
            log.warn((Object)("This entity (" + entity.getEntity().getName() + " is the root in the class hierarchy and " + "has a pk joincolum annotation, this is not correct, ignoring pk joincolumn annotation"));
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)entity.getInheritanceStrategy()) && entity.getPrimaryKeyJoinColumns() != null && entity.getPrimaryKeyJoinColumns().size() > 0) {
            log.warn((Object)("Single table inheritance strategy (entity " + entity.getEntity().getName() + ", primary key join column annotation is ignored for subclass"));
        } else if (entity.getPrimaryKeyJoinColumns() != null && entity.getPrimaryKeyJoinColumns().size() > 0) {
            this.addPrimaryKeyJoinColumn((List<PrimaryKeyJoinColumn>)entity.getPrimaryKeyJoinColumns(), entity);
        } else if (entity.getPaSuperEntity() != null && InheritanceType.JOINED.equals((Object)entity.getInheritanceStrategy())) {
            ArrayList<PrimaryKeyJoinColumn> list = new ArrayList<PrimaryKeyJoinColumn>();
            PrimaryKeyJoinColumn pkjc = PannotationFactory.eINSTANCE.createPrimaryKeyJoinColumn();
            String entityName = mc.getEntityName(entity.getModelEClass());
            mc.trunc(String.valueOf(entityName) + "id");
            list.add(pkjc);
            this.addPrimaryKeyJoinColumn(list, entity);
        }
        try {
            List inheritedFeatures = mc.getInheritedFeatures(entity);
            mc.setForceOptional(entity.getPaSuperEntity() != null && (entity.getInheritanceStrategy() == null || InheritanceType.SINGLE_TABLE.equals((Object)entity.getInheritanceStrategy())));
            mc.pushOverrideOnStack();
            mc.addAttributeOverrides(entity.getAttributeOverrides());
            mc.addAssociationOverrides(entity.getAssociationOverrides());
            if (inheritedFeatures.size() > 0) {
                log.debug((Object)("There are " + inheritedFeatures.size() + " inherited features "));
            }
            try {
                this.processFeatures(inheritedFeatures);
                EList secondaryTables = entity.getSecondaryTables();
                if (secondaryTables == null || secondaryTables.isEmpty()) {
                    this.processFeatures((List<PAnnotatedEStructuralFeature>)entity.getPaEStructuralFeatures());
                } else {
                    this.processSecondaryTables((List<SecondaryTable>)secondaryTables, entity);
                }
            }
            finally {
                mc.popOverrideStack();
            }
        }
        catch (Throwable throwable) {
            int index2;
            mc.setForceOptional(false);
            mc.setCurrentTable(null);
            Element idElement = entityElement.element("id");
            if (idElement == null) {
                idElement = entityElement.element("composite-id");
            }
            if (idElement == null && entity.getPaSuperEntity() == null && entity.getPaMappedSupers().size() == 0) {
                idElement = IdMapper.addSyntheticId(this.hbmContext, entityElement);
            } else if (mc.mustAddSyntheticID(entity)) {
                idElement = IdMapper.addSyntheticId(this.hbmContext, entityElement);
            } else {
                this.addAccessor(idElement, this.hbmContext.getIdPropertyHandlerName());
            }
            if (idElement != null) {
                index2 = entityElement.indexOf(idElement) + 1;
                if (((HbAnnotatedEClass)entity).getDiscriminatorFormula() != null) {
                    entityElement.add(index2++, this.createDiscriminatorElement(hbEntity.getDiscriminatorFormula(), entity.getDiscriminatorColumn(), hbEntity.getForceDiscriminator() != null));
                } else if (entity.getDiscriminatorColumn() != null) {
                    entityElement.add(index2++, this.createDiscriminatorElement(entity.getDiscriminatorColumn(), hbEntity.getForceDiscriminator() != null));
                }
                Element versionElement = entityElement.element("version");
                if (versionElement == null) {
                    versionElement = this.addVersionProperty(hbEntity);
                }
                if (versionElement != null) {
                    entityElement.remove(versionElement);
                    entityElement.add(index2, versionElement);
                }
            }
            this.mapFilter(entityElement, (List<Filter>)((HbAnnotatedEClass)entity).getFilter());
            mc.setCurrent(entityElement.getParent());
            this.processFeatureMapFeatures();
            index2 = 1 + entityElement.getChildren().indexOf(idElement);
            if (entityElement.element("discriminator") != null) {
                Element elem = entityElement.element("discriminator");
                index2 = 1 + entityElement.getChildren().indexOf(elem);
            }
            this.handleNaturalId(entityElement, index2);
            throw throwable;
        }
        mc.setForceOptional(false);
        mc.setCurrentTable(null);
        Element idElement = entityElement.element("id");
        if (idElement == null) {
            idElement = entityElement.element("composite-id");
        }
        if (idElement == null && entity.getPaSuperEntity() == null && entity.getPaMappedSupers().size() == 0) {
            idElement = IdMapper.addSyntheticId(this.hbmContext, entityElement);
        } else if (mc.mustAddSyntheticID(entity)) {
            idElement = IdMapper.addSyntheticId(this.hbmContext, entityElement);
        } else {
            this.addAccessor(idElement, this.hbmContext.getIdPropertyHandlerName());
        }
        if (idElement != null) {
            index = entityElement.indexOf(idElement) + 1;
            if (((HbAnnotatedEClass)entity).getDiscriminatorFormula() != null) {
                entityElement.add(index++, this.createDiscriminatorElement(hbEntity.getDiscriminatorFormula(), entity.getDiscriminatorColumn(), hbEntity.getForceDiscriminator() != null));
            } else if (entity.getDiscriminatorColumn() != null) {
                entityElement.add(index++, this.createDiscriminatorElement(entity.getDiscriminatorColumn(), hbEntity.getForceDiscriminator() != null));
            }
            Element versionElement = entityElement.element("version");
            if (versionElement == null) {
                versionElement = this.addVersionProperty(hbEntity);
            }
            if (versionElement != null) {
                entityElement.remove(versionElement);
                entityElement.add(index, versionElement);
            }
        }
        this.mapFilter(entityElement, (List<Filter>)((HbAnnotatedEClass)entity).getFilter());
        mc.setCurrent(entityElement.getParent());
        this.processFeatureMapFeatures();
        index = 1 + entityElement.getChildren().indexOf(idElement);
        if (entityElement.element("discriminator") != null) {
            Element elem = entityElement.element("discriminator");
            index = 1 + entityElement.getChildren().indexOf(elem);
        }
        this.handleNaturalId(entityElement, index);
        Element comment = this.addCommentElement((EModelElement)entity.getModelEClass(), entityElement);
        if (comment != null) {
            entityElement.remove(comment);
            entityElement.add(0, comment);
        }
        mc.addTuplizerElement(entityElement, entity);
        if ((entity.getPaSuperEntity() == null || entity.getPaSuperEntity().getMappedSuperclass() != null) && ((HbAnnotatedEClass)entity).getHbCache() != null) {
            this.addCacheElement(entityElement, ((HbAnnotatedEClass)entity).getHbCache());
        }
        Element meta1 = new Element("meta");
        meta1.addAttribute("attribute", "eclassName").addText(entity.getModelEClass().getName());
        Element meta2 = new Element("meta");
        meta2.addAttribute("attribute", "epackage").addText(entity.getModelEClass().getEPackage().getNsURI());
        entityElement.add(0, meta1);
        entityElement.add(1, meta2);
        ArrayList<Element> toMove = new ArrayList<Element>();
        for (Element elem : entityElement.getChildren()) {
            if (!elem.getName().equals("join")) continue;
            toMove.add(elem);
        }
        entityElement.getChildren().removeAll(toMove);
        entityElement.getChildren().addAll(toMove);
    }

    protected void handleNaturalId(Element parentElement, int index) {
        log.debug((Object)"Checking for natural-ids");
        ArrayList<Element> naturalIdElements = new ArrayList<Element>();
        boolean mutable = false;
        for (Element element : parentElement.getChildren()) {
            String value = element.getAttributeValue("natural-id");
            if (value == null) continue;
            if (naturalIdElements.isEmpty()) {
                log.debug((Object)("Found natural-id, mutable: " + mutable));
                mutable = Boolean.parseBoolean(value);
            }
            naturalIdElements.add(element);
            element.removeAttribute("natural-id");
        }
        if (!naturalIdElements.isEmpty()) {
            log.debug((Object)("Found " + naturalIdElements.size() + " naturalid properies, putting them inside a natural-id tag"));
            parentElement.getChildren().removeAll(naturalIdElements);
            Element naturalId = parentElement.addElement("natural-id");
            parentElement.remove(naturalId);
            naturalId.addAttribute("mutable", Boolean.toString(mutable));
            parentElement.add(index, naturalId);
            naturalId.getChildren().addAll(naturalIdElements);
            for (Element element : naturalIdElements) {
                element.setParent(naturalId);
            }
        }
    }

    private void processFeatureMapFeatures() {
        List<FeatureMapMapping> featureMapMappers = this.getHbmContext().getClearFeatureMapMappers();
        while (featureMapMappers.size() > 0) {
            for (FeatureMapMapping fmm : featureMapMappers) {
                fmm.process();
            }
            featureMapMappers = this.getHbmContext().getClearFeatureMapMappers();
        }
    }

    protected void processMappedSuper(PAnnotatedEClass paMappedSuper) {
        this.processFeatures((List<PAnnotatedEStructuralFeature>)paMappedSuper.getPaEStructuralFeatures());
    }

    protected void processFeatures(List<PAnnotatedEStructuralFeature> features) {
        for (PAnnotatedEStructuralFeature annotatedEStructuralFeature : features) {
            this.processFeature(annotatedEStructuralFeature);
        }
    }

    protected void processSecondaryTables(List<SecondaryTable> secondaryTables, PAnnotatedEClass entity) {
        HashSet<String> tableNames = new HashSet<String>();
        tableNames.add(this.PRIMARY_TABLE_KEY);
        for (SecondaryTable secondaryTable : secondaryTables) {
            tableNames.add(secondaryTable.getName());
        }
        HashMap<Object, ArrayList<PAnnotatedEStructuralFeature>> featuresByTable = new HashMap<Object, ArrayList<PAnnotatedEStructuralFeature>>();
        for (PAnnotatedEStructuralFeature feature : entity.getPaEStructuralFeatures()) {
            String tableName = this.getHbmContext().getSecondaryTableName(feature);
            if (!tableNames.contains(tableName)) {
                String message = "Feature \"" + feature.getModelElement().getName() + "\" was mapped to undeclared secondary table \"" + (String)tableName + "\".";
                log.error((Object)message);
                throw new MappingException(message);
            }
            ArrayList<PAnnotatedEStructuralFeature> featuresInTable = (ArrayList<PAnnotatedEStructuralFeature>)featuresByTable.get(tableName);
            if (featuresInTable == null) {
                featuresInTable = new ArrayList<PAnnotatedEStructuralFeature>();
                featuresByTable.put(tableName, featuresInTable);
            }
            featuresInTable.add(feature);
        }
        List featuresInTable = (List)featuresByTable.get(this.PRIMARY_TABLE_KEY);
        if (featuresInTable != null) {
            for (PAnnotatedEStructuralFeature feature : featuresInTable) {
                this.processFeature(feature);
            }
        }
        for (SecondaryTable secondaryTable : secondaryTables) {
            if (!featuresByTable.containsKey(secondaryTable.getName())) {
                log.warn((Object)("No features mapped to secondary table " + secondaryTable.getName()));
                continue;
            }
            List featuresInTable2 = (List)featuresByTable.get(secondaryTable.getName());
            Element joinElement = this.getHbmContext().getCurrent().addElement("join");
            joinElement.addAttribute("table", this.getHbmContext().trunc(secondaryTable.getName().toUpperCase(), false));
            log.debug((Object)("Mapping features to secondary table \"" + secondaryTable.getName() + "\""));
            if (secondaryTable.getCatalog() != null) {
                joinElement.addAttribute("catalog", secondaryTable.getCatalog());
            }
            if (secondaryTable.getSchema() != null) {
                joinElement.addAttribute("schema", secondaryTable.getSchema());
            }
            entity.getModelEClass().getEIDAttribute();
            EList pkJoinColumns = secondaryTable.getPkJoinColumns();
            Element keyElement = joinElement.addElement("key");
            for (PrimaryKeyJoinColumn pkJoinColumn : pkJoinColumns) {
                keyElement.addElement("column").addAttribute("name", this.getHbmContext().trunc(pkJoinColumn.getName()));
            }
            this.handleOndelete(keyElement, ((HbAnnotatedEClass)entity).getHbOnDelete());
            try {
                this.getHbmContext().setCurrent(joinElement);
                this.getHbmContext().setCurrentSecondaryTable(secondaryTable);
                for (PAnnotatedEStructuralFeature feature : featuresInTable2) {
                    this.processFeature(feature);
                }
            }
            finally {
                this.getHbmContext().setCurrentSecondaryTable(null);
                this.getHbmContext().setCurrent(joinElement.getParent());
            }
        }
    }

    protected void processFeature(PAnnotatedEStructuralFeature paFeature) {
        this.hbmContext.getFeatureMapper().process(paFeature);
    }

    private void addPrimaryKeyJoinColumn(List<PrimaryKeyJoinColumn> pkJCs, PAnnotatedEClass entity) {
        log.debug((Object)"Adding primary key join column");
        Element jcElement = this.getHbmContext().getCurrent().addElement("key");
        this.handleOndelete(jcElement, ((HbAnnotatedEClass)entity).getHbOnDelete());
        for (PrimaryKeyJoinColumn pkJC : pkJCs) {
            Element columnElement = jcElement.addElement("column");
            if (pkJC.getColumnDefinition() != null) {
                log.error((Object)("Unsupported column definition in primary key join column " + pkJC));
                throw new MappingException("Unsupported column definition in primary key join column", (PAnnotation)pkJC);
            }
            if (pkJC.getName() != null) {
                columnElement.addAttribute("name", this.getHbmContext().trunc(pkJC.getName()));
            }
            if (pkJC.getReferencedColumnName() == null) continue;
            columnElement.addAttribute("property-ref", pkJC.getReferencedColumnName());
        }
    }

    private Element createDiscriminatorElement(DiscriminatorColumn dColumn, boolean force) {
        Element dcElement = DocumentHelper.createElement((String)"discriminator");
        if (dColumn.getColumn() != null) {
            Column col = dColumn.getColumn();
            Element colElement = dcElement.addElement("column");
            colElement.addAttribute("name", col.getName());
            if (col.getIndex() != null) {
                colElement.addAttribute("index", col.getIndex());
            }
            if (EntityMapper.hbDiscriminatorType(dColumn.getDiscriminatorType()).equals("string") && col.getLength() > 0) {
                colElement.addAttribute("length", Integer.toString(col.getLength()));
            }
            if (!col.isNullable()) {
                colElement.addAttribute("not-null", "true");
            }
        } else if (dColumn.getName() != null) {
            dcElement.addAttribute("column", this.getHbmContext().trunc(dColumn.getName()));
        }
        dcElement.addAttribute("type", EntityMapper.hbDiscriminatorType(dColumn.getDiscriminatorType()));
        if (force) {
            dcElement.addAttribute("force", "true");
        }
        if (dColumn.isSetLength() && log.isDebugEnabled()) {
            log.debug((Object)("Ignoring length for discriminator column " + dColumn));
        }
        if (dColumn.getColumnDefinition() != null) {
            log.error((Object)("Unsupported column definition in discriminator column " + dColumn));
            throw new MappingException("Unsupported column definition in discriminator column", (PAnnotation)dColumn);
        }
        return dcElement;
    }

    private Element createDiscriminatorElement(DiscriminatorFormula formula, DiscriminatorColumn dc, boolean force) {
        Element dcElement = DocumentHelper.createElement((String)"discriminator");
        dcElement.addAttribute("formula", formula.getValue());
        if (force) {
            dcElement.addAttribute("force", "true");
        }
        if (dc != null && dc.getDiscriminatorType() != null) {
            dcElement.addAttribute("type", EntityMapper.hbDiscriminatorType(dc.getDiscriminatorType()));
        }
        return dcElement;
    }

    private Element addVersionProperty(HbAnnotatedEClass aClass) {
        boolean skipVersionOnImmutable;
        assert (this.getHbmContext().getCurrent().element("version") == null);
        if (!this.getHbmContext().alwaysVersion()) {
            return null;
        }
        boolean bl = skipVersionOnImmutable = this.getHbmContext().getPersistenceOptions().isDiscriminatorVersionOnImmutableEClass() == false;
        if (aClass.getImmutable() != null && skipVersionOnImmutable) {
            return null;
        }
        Element versionElement = this.getHbmContext().getCurrent().addElement("version").addAttribute("name", this.getHbmContext().getVersionColumnName()).addAttribute("column", this.getHbmContext().getVersionColumnName());
        Element meta = new Element("meta");
        meta.addAttribute("attribute", "syntheticVersion").addText("true");
        versionElement.add(0, meta);
        versionElement.addAttribute("access", this.getHbmContext().getSyntheticVersionPropertyHandlerName());
        return versionElement;
    }
}

