/*
 * Decompiled with CFR 0.152.
 */
package temporal.mod;

import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import temporal.Temporal;
import temporal.TemporalFactory;
import temporal.TemporalPackage;
import temporal.VersionHolder;
import temporal.mod.TemporalBaseEObjectImpl;
import temporal.mod.TemporalCopier;
import temporal.mod.TemporalDateProvider;
import temporal.mod.TemporalEStoreImpl;

public class TemporalUtil {
    public static VersionHolder getVersionHolder(EObject eObject) {
        return (VersionHolder)eObject.eGet((EStructuralFeature)TemporalPackage.Literals.TEMPORAL__VERSION_HOLDER, true);
    }

    public static Date getDate(EObject eObject) {
        return (Date)eObject.eGet((EStructuralFeature)TemporalPackage.Literals.TEMPORAL__DATE, true);
    }

    public static Date getTrimedNow() {
        return TemporalDateProvider.eINSTANCE.trimDate(TemporalDateProvider.eINSTANCE.now(), TemporalDateProvider.eINSTANCE.getGranularity());
    }

    public static void initTemporal(EObject eObject) {
        if (eObject instanceof Temporal) {
            ((TemporalEStoreImpl)((TemporalBaseEObjectImpl)eObject).eStore()).setBypass(true);
            eObject.eSet((EStructuralFeature)TemporalPackage.Literals.TEMPORAL__DATE, (Object)TemporalUtil.getTrimedNow());
            VersionHolder newVersionHolder = TemporalFactory.eINSTANCE.createVersionHolder();
            eObject.eSet((EStructuralFeature)TemporalPackage.Literals.TEMPORAL__VERSION_HOLDER_CONTAINMENT, (Object)newVersionHolder);
            eObject.eSet((EStructuralFeature)TemporalPackage.Literals.TEMPORAL__VERSION_HOLDER, (Object)newVersionHolder);
            ((TemporalEStoreImpl)((TemporalBaseEObjectImpl)eObject).eStore()).setBypass(false);
        }
    }

    public static Temporal versionAt(EObject eObject, Date date) {
        boolean continuityPresent;
        Temporal version = null;
        Temporal continuity = null;
        Date continuityDate = null;
        EList versions = TemporalUtil.versions(eObject);
        VersionHolder vh = TemporalUtil.getVersionHolder(eObject);
        int indexOfContinuity = vh.getIndexOfContinuity();
        boolean bl = continuityPresent = versions.size() > 0;
        if (!continuityPresent) {
            return null;
        }
        continuity = (Temporal)versions.get(indexOfContinuity);
        continuityDate = continuity.getDate();
        if (TemporalDateProvider.eINSTANCE.areEqual(continuityDate, date, TemporalDateProvider.eINSTANCE.getGranularity())) {
            return continuity;
        }
        Date trimmedDate = TemporalDateProvider.eINSTANCE.trimDate(date, TemporalDateProvider.eINSTANCE.getGranularity());
        for (Temporal curr : versions) {
            Date currDate = curr.getDate();
            if (trimmedDate.compareTo(currDate) < 0) continue;
            version = curr;
            break;
        }
        return version;
    }

    public static Temporal createVersion(EObject eObject) {
        assert (eObject instanceof Temporal);
        return TemporalCopier.createVersion((Temporal)eObject, TemporalUtil.getTrimedNow());
    }

    public static boolean isDateWithinVersion(EObject eObject, Date date) {
        return TemporalDateProvider.eINSTANCE.areEqual(date, TemporalUtil.getDate(eObject), TemporalDateProvider.eINSTANCE.getGranularity());
    }

    public static Temporal continuity(EObject eObject) {
        EList versions = TemporalUtil.versions(eObject);
        assert (versions.size() > 0);
        return (Temporal)versions.get(TemporalUtil.getVersionHolder(eObject).getIndexOfContinuity());
    }

    public static Temporal currentVersion(EObject eObject) {
        return TemporalUtil.versionAt(eObject, TemporalDateProvider.eINSTANCE.now());
    }

    public static EList versions(EObject eObject) {
        VersionHolder vh = TemporalUtil.getVersionHolder(eObject);
        if (vh == null) assert (false);
        return vh.getVersions();
    }
}

