/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceFileProvider;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbEntityManagerWrapper;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingUtil;
import org.eclipse.emf.teneo.hibernate.mapping.EMFInitializeCollectionEventListener;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.event.InitializeCollectionEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbEntityDataStore
extends HbDataStore
implements EntityManagerFactory {
    private static Log log = LogFactory.getLog(HbEntityDataStore.class);
    private EntityManagerFactory entityManagerFactory;
    private Ejb3Configuration ejb3Configuration;

    @Override
    public void initialize() {
        MappingUtil.registerHbExtensions((ExtensionManager)this.getExtensionManager());
        log.debug((Object)"Initializing EJB3 Hb Entity DataStore");
        if (this.getEPackages() == null) {
            throw new HbMapperException("EPackages are not set");
        }
        this.setInterceptor(null);
        log.debug((Object)">>>>> Creating EJB3 Configuration");
        this.ejb3Configuration = this.createConfiguration();
        this.mapModel();
        this.setPropertiesInConfiguration();
        this.initializeDataStore();
        if (this.entityManagerFactory != null && this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
        this.entityManagerFactory = this.buildEntityManagerFactory();
        HbHelper.INSTANCE.register(this);
        this.setInitialized(true);
    }

    @Override
    protected void buildMappings() {
        this.getConfiguration().buildMappings();
    }

    @Override
    protected void setEventListeners() {
        EMFInitializeCollectionEventListener eventListener = (EMFInitializeCollectionEventListener)((Object)this.getExtensionManager().getExtension(EMFInitializeCollectionEventListener.class));
        this.getConfiguration().getEventListeners().setInitializeCollectionEventListeners(new InitializeCollectionEventListener[]{eventListener});
    }

    @Override
    protected void setInterceptor() {
        if (this.getInterceptor() != null) {
            return;
        }
        Interceptor interceptor = this.getHbContext().createInterceptor(this.getHibernateConfiguration(), this.getEntityNameStrategy());
        this.getConfiguration().setInterceptor(interceptor);
        this.setInterceptor(interceptor);
    }

    protected Ejb3Configuration createConfiguration() {
        return new Ejb3Configuration();
    }

    protected void setPropertiesInConfiguration() {
        Properties properties = this.getProperties();
        if (properties != null) {
            this.setDefaultProperties(properties);
            this.getConfiguration().addProperties(properties);
        }
    }

    protected void mapModel() {
        if (this.getPersistenceOptions().isUseMappingFile() || this.getPersistenceOptions().getMappingFilePath() != null) {
            String[] fileList;
            log.debug((Object)"Searching hbm files in class paths of epackages");
            String[] stringArray = fileList = this.getMappingFileList();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                log.debug((Object)("Adding file " + element + " to Hibernate Configuration"));
                PersistenceFileProvider pfp = (PersistenceFileProvider)this.getExtensionManager().getExtension(PersistenceFileProvider.class);
                InputStream is = pfp.getFileContent(this.getClass(), element);
                if (is == null) {
                    throw new HbStoreException("Path to mapping file: " + element + " does not exist!");
                }
                this.getConfiguration().addInputStream(is);
                ++n2;
            }
        } else {
            this.setMappingXML(this.mapEPackages());
            StringBufferInputStream is = new StringBufferInputStream(this.getMappingXML());
            this.getConfiguration().addInputStream((InputStream)is);
        }
    }

    protected EntityManagerFactory buildEntityManagerFactory() {
        return this.getConfiguration().createEntityManagerFactory();
    }

    @Override
    public void close() {
        if (this.getEntityManagerFactory().isOpen()) {
            this.getEntityManagerFactory().close();
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        assert (this.entityManagerFactory != null);
        return this.entityManagerFactory;
    }

    @Override
    public SessionWrapper createSessionWrapper() {
        return new HbEntityManagerWrapper(this);
    }

    public Ejb3Configuration getConfiguration() {
        return this.ejb3Configuration;
    }

    @Override
    public Configuration getHibernateConfiguration() {
        return this.ejb3Configuration.getHibernateConfiguration();
    }

    @Override
    public Iterator<?> getClassMappings() {
        return this.getConfiguration().getClassMappings();
    }

    @Override
    public SessionFactory getSessionFactory() {
        throw new UnsupportedOperationException("This method should not be called, use getEntityManagerFactory");
    }

    public EntityManager createEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }

    public EntityManager createEntityManager(Map arg0) {
        return this.getEntityManagerFactory().createEntityManager(arg0);
    }

    public boolean isOpen() {
        return this.getEntityManagerFactory().isOpen();
    }
}

