/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.property;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.GeneratedValue;
import org.eclipse.emf.teneo.annotations.pannotation.GenerationType;
import org.eclipse.emf.teneo.annotations.pannotation.SequenceGenerator;
import org.eclipse.emf.teneo.annotations.pannotation.TableGenerator;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.AbstractMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class IdMapper
extends AbstractMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(IdMapper.class);

    public void map(PAnnotatedEAttribute aAttribute, Element classElement) {
        log.debug((Object)("Processing id annotation:" + aAttribute.getModelElement().getName()));
        Element fieldElement = classElement.addElement("field");
        fieldElement.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)aAttribute.getModelElement())).addAttribute("persistence-modifier", "persistent");
        fieldElement.addAttribute("primary-key", "true");
        Column overridden = this.mappingContext.getAttributeOverride((PAnnotatedEStructuralFeature)aAttribute);
        if (overridden != null) {
            this.mappingContext.getColumnMapper().map(overridden, fieldElement);
        } else if (aAttribute.getColumn() != null) {
            this.mappingContext.getColumnMapper().map(aAttribute.getColumn(), fieldElement);
        } else if (this.mappingContext.getEmbeddingFeature() != null) {
            PAnnotatedEStructuralFeature pae = this.mappingContext.getEmbeddingFeature();
            String name = String.valueOf(pae.getModelEStructuralFeature().getName()) + "_" + aAttribute.getModelEAttribute().getName() + "_ID";
            fieldElement.addAttribute("column", name);
        }
        GeneratedValue gv = aAttribute.getGeneratedValue();
        if (gv != null) {
            if (gv.getStrategy() == GenerationType.AUTO) {
                fieldElement.addAttribute("value-strategy", "auto");
            } else if (gv.getStrategy() == GenerationType.SEQUENCE) {
                log.warn((Object)"The identity value-strategy of sequence is only supported for a limited set of databases");
                fieldElement.addAttribute("value-strategy", "sequence");
            } else if (gv.getStrategy() == GenerationType.IDENTITY) {
                fieldElement.addAttribute("value-strategy", "identity");
            } else if (gv.getStrategy() == GenerationType.TABLE) {
                fieldElement.addAttribute("value-strategy", "increment");
            } else {
                log.error((Object)("VALUE-STRATEGY: " + gv.getStrategy().getName() + " not supported for field " + aAttribute.getModelElement().getName()));
            }
            fieldElement.addAttribute("indexed", "true");
            if (gv.getGenerator() != null) {
                if (GenerationType.TABLE.equals((Object)gv.getStrategy())) {
                    fieldElement.addAttribute("strategy", "increment");
                    TableGenerator tg = aAttribute.getPaModel().getTableGenerator((EStructuralFeature)aAttribute.getModelEAttribute(), gv.getGenerator());
                    if (tg.getTable() != null) {
                        fieldElement.addAttribute("sequence-table-name", tg.getTable());
                    }
                    if (tg.getPkColumnName() != null) {
                        fieldElement.addAttribute("sequence-name-column-name", tg.getPkColumnName());
                    }
                    if (tg.getValueColumnName() != null) {
                        fieldElement.addAttribute("sequence-nextval-column-name", tg.getValueColumnName());
                    }
                } else {
                    SequenceGenerator sg = aAttribute.getPaModel().getSequenceGenerator((EStructuralFeature)aAttribute.getModelEAttribute(), gv.getGenerator());
                    fieldElement.addAttribute("sequence", sg.getSequenceName());
                }
            }
        }
    }
}

