/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.teneo.eclipselink.emap.EclipseLinkEMap;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfHelper {
    private static EmfHelper instance = new EmfHelper();
    private Field delegateEListField;
    private Field eObjectEListFeatureIDField;
    private Field eObjectEListOwnerField;
    private Field ecoreEMapEntryEClassField;
    private Field ecoreEMapEntryClassField;

    private EmfHelper() {
        try {
            this.delegateEListField = Helper.getField(BasicEMap.class, (String)"delegateEList");
            this.eObjectEListFeatureIDField = Helper.getField(EObjectEList.class, (String)"featureID");
            this.eObjectEListOwnerField = Helper.getField(EObjectEList.class, (String)"owner");
            this.ecoreEMapEntryEClassField = Helper.getField(EcoreEMap.class, (String)"entryEClass");
            this.ecoreEMapEntryClassField = Helper.getField(EcoreEMap.class, (String)"entryClass");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Can't get delegateEList field from BasicEMap", e);
        }
    }

    public static EmfHelper getInstance() {
        return instance;
    }

    public <E, K, V> void setECollectionContents(Collection<E> listContents, EList<E> targetList) {
        if (listContents instanceof EMap) {
            EmfHelper.getInstance().setEMapContents((EMap)listContents, (EMap)targetList);
        } else {
            EmfHelper.getInstance().setEListContents(listContents, targetList);
        }
    }

    public <E> void setEListContents(Collection<E> listContents, EList<E> targetList) {
        if (targetList instanceof EcoreEList) {
            Object[] contentsArray = listContents.toArray();
            try {
                this.basicSetEListContents(targetList, contentsArray);
            }
            catch (Exception e) {
                e.printStackTrace();
                new RuntimeException("Cannot set owner on Elist", e);
            }
        } else {
            throw new RuntimeException("Exception setting EList contents: unsupported collection class: " + targetList.getClass());
        }
    }

    public <E> boolean addToEList(EList<E> eList, E element) {
        if (eList instanceof BasicEList) {
            int size = eList.size();
            int newSize = size + 1;
            try {
                Method growMethod = PrivilegedAccessHelper.getDeclaredMethod(BasicEList.class, (String)"grow", (Class[])new Class[]{Integer.TYPE});
                growMethod.setAccessible(true);
                growMethod.invoke(eList, newSize);
                Field sizeField = PrivilegedAccessHelper.getDeclaredField(BasicEList.class, (String)"size", (boolean)true);
                sizeField.set(eList, newSize);
                Method assignMethod = PrivilegedAccessHelper.getDeclaredMethod(BasicEList.class, (String)"assign", (Class[])new Class[]{Integer.TYPE, Object.class});
                assignMethod.setAccessible(true);
                assignMethod.invoke(eList, size, element);
            }
            catch (Exception e) {
                e.printStackTrace();
                new RuntimeException("Exception adding element to EList:", e);
            }
            return true;
        }
        return eList.add(element);
    }

    public boolean removeFromEList(EList<?> eList, Object object) {
        if (eList instanceof BasicEList) {
            try {
                int size = eList.size();
                int index = eList.indexOf(object);
                Field dataField = Helper.getField(eList.getClass(), (String)"data");
                Object[] data = (Object[])dataField.get(eList);
                if (index >= 0) {
                    int shifted = size - index - 1;
                    if (shifted > 0) {
                        System.arraycopy(data, index + 1, data, index, shifted);
                    }
                    data[--size] = null;
                }
                Field sizeField = PrivilegedAccessHelper.getDeclaredField(BasicEList.class, (String)"size", (boolean)true);
                sizeField.set(eList, size);
            }
            catch (Exception e) {
                e.printStackTrace();
                new RuntimeException("Exception removing element from EList:", e);
            }
            return true;
        }
        return eList.remove(object);
    }

    private void basicSetEListContents(EList<?> targetList, Object[] contentsArray) throws NoSuchFieldException, IllegalAccessException {
        Field dataField = Helper.getField(targetList.getClass(), (String)"data");
        PrivilegedAccessHelper.setValueInField((Field)dataField, targetList, (Object)contentsArray);
        Field sizeField = Helper.getField(targetList.getClass(), (String)"size");
        PrivilegedAccessHelper.setValueInField((Field)sizeField, targetList, (Object)contentsArray.length);
    }

    public <K, V> void setEMapContents(EMap<K, V> mapContents, EMap<K, V> targetMap) {
        try {
            if (targetMap instanceof BasicEMap) {
                BasicEMap basicEMap = (BasicEMap)targetMap;
                Method basicEMapEnsureEntryDataExistsMethod = PrivilegedAccessHelper.getDeclaredMethod(BasicEMap.class, (String)"ensureEntryDataExists", (Class[])new Class[0]);
                basicEMapEnsureEntryDataExistsMethod.setAccessible(true);
                basicEMapEnsureEntryDataExistsMethod.invoke((Object)basicEMap, new Object[0]);
                Method basicEMapDoPutMethod = PrivilegedAccessHelper.getDeclaredMethod(BasicEMap.class, (String)"doPut", (Class[])new Class[]{BasicEMap.Entry.class});
                basicEMapDoPutMethod.setAccessible(true);
                for (Object entry : mapContents.entrySet()) {
                    basicEMapDoPutMethod.invoke((Object)basicEMap, entry);
                }
                EList delegateEList = (EList)this.delegateEListField.get(basicEMap);
                this.basicSetEListContents(delegateEList, mapContents.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            new RuntimeException("Exception setting EMap contents:", e);
        }
    }

    public <K, V> boolean addToEMap(EMap<K, V> eMap, Map.Entry<K, V> entry) {
        if (eMap instanceof EclipseLinkEMap) {
            return EmfHelper.getInstance().addToEList((EList)eMap, (Object)entry);
        }
        if (eMap instanceof BasicEMap) {
            try {
                BasicEMap basicEMap = (BasicEMap)eMap;
                Method basicEMapEnsureEntryDataExistsMethod = PrivilegedAccessHelper.getDeclaredMethod(BasicEMap.class, (String)"ensureEntryDataExists", (Class[])new Class[0]);
                basicEMapEnsureEntryDataExistsMethod.setAccessible(true);
                basicEMapEnsureEntryDataExistsMethod.invoke((Object)basicEMap, new Object[0]);
                Method basicEMapDoPutMethod = PrivilegedAccessHelper.getDeclaredMethod(BasicEMap.class, (String)"doPut", (Class[])new Class[]{BasicEMap.Entry.class});
                basicEMapDoPutMethod.setAccessible(true);
                basicEMapDoPutMethod.invoke((Object)basicEMap, entry);
                EList delegateEList = (EList)this.delegateEListField.get(basicEMap);
                this.addToEList(delegateEList, entry);
            }
            catch (Exception e) {
                e.printStackTrace();
                new RuntimeException("Exception adding to EMap:", e);
            }
            return true;
        }
        throw new RuntimeException("Collection class not supported: " + eMap.getClass().getName());
    }

    public <K, V> BasicEList<Map.Entry<K, V>> getEMapDelegateEList(BasicEMap<K, V> originalEMap) {
        try {
            return (BasicEList)this.delegateEListField.get(originalEMap);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception getting delegate list");
        }
    }

    public Class<? extends Map.Entry> getEcoreEMapEntryClass(EcoreEMap<?, ?> map) {
        try {
            return (Class)this.ecoreEMapEntryClassField.get(map);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception getting delegate list");
        }
    }

    public EClass getEcoreEMapEntryEClass(EcoreEMap<?, ?> map) {
        try {
            return (EClass)this.ecoreEMapEntryEClassField.get(map);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception getting entryEClass");
        }
    }

    public InternalEObject getEObjectEListOwner(EObjectEList<?> map) {
        try {
            return (InternalEObject)this.eObjectEListOwnerField.get(map);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception getting list owner");
        }
    }

    public void setEObjectEListOwner(EObjectEList<?> list, InternalEObject owner) {
        try {
            this.eObjectEListOwnerField.set(list, owner);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception setting list owner");
        }
    }

    public int getEObjectEListFeatureId(EObjectEList<?> list) {
        try {
            return this.eObjectEListFeatureIDField.getInt(list);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception getting featureID");
        }
    }
}

