/*
 * Decompiled with CFR 0.152.
 */
package jpoxtutorial;

import java.util.Properties;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.jpox.JpoxDataStore;
import org.eclipse.emf.teneo.jpox.JpoxHelper;
import org.eclipse.example.library.Book;
import org.eclipse.example.library.BookCategory;
import org.eclipse.example.library.Library;
import org.eclipse.example.library.LibraryFactory;
import org.eclipse.example.library.LibraryPackage;
import org.eclipse.example.library.Writer;

public class QuickStart {
    public static void main(String[] args) {
        String dbName = "library";
        QuickStart.doQuickStart(dbName);
    }

    public static JpoxDataStore doQuickStart(String dbName) {
        String pmfName = "MyPMF";
        Properties properties = new Properties();
        properties.setProperty("javax.jdo.option.ConnectionDriverName", "com.mysql.jdbc.Driver");
        properties.setProperty("javax.jdo.option.ConnectionURL", "jdbc:mysql://127.0.0.1:3306/mylibrary");
        properties.setProperty("javax.jdo.option.ConnectionUserName", "root");
        properties.setProperty("javax.jdo.option.ConnectionPassword", "root");
        JpoxDataStore jpoxDataStore = JpoxHelper.INSTANCE.createRegisterDataStore(pmfName);
        jpoxDataStore.setProperties(properties);
        jpoxDataStore.setEPackages(new EPackage[]{LibraryPackage.eINSTANCE});
        jpoxDataStore.initialize();
        PersistenceManager pm = jpoxDataStore.getPMF().getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        tx.begin();
        Library lib = LibraryFactory.eINSTANCE.createLibrary();
        lib.setName("My Library");
        pm.makePersistent((Object)lib);
        Writer writer = LibraryFactory.eINSTANCE.createWriter();
        writer.setName("JRR Tolkien");
        Book book = LibraryFactory.eINSTANCE.createBook();
        book.setAuthor(writer);
        book.setPages(305);
        book.setTitle("The Hobbit");
        book.setCategory(BookCategory.SCIENCE_FICTION);
        lib.getWriters().add((Object)writer);
        lib.getBooks().add((Object)book);
        tx.commit();
        pm.close();
        return jpoxDataStore;
    }
}

