/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.notloadedfragment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ThreeWayComparisonGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class NotLoadedFragmentNodeTest {
    private static final String RIGHT_SIDE = "Right Side";
    private static final String LEFT_SIDE = "Left Side";
    private static final String CONFLICTS = "Conflicts";
    private static final String ELLIPSIS = "[ ... ]";
    private static String SEP = File.separator;
    private static AdapterFactoryItemDelegator itemDelegator;
    private EventBus eventBus;
    private static final Function<Object, EObject> TREE_NODE_DATA;
    private static final Predicate<Object> NOT_LOADED_FRAGMENT;

    static {
        TREE_NODE_DATA = new Function<Object, EObject>(){

            public EObject apply(Object node) {
                if (node instanceof TreeNode) {
                    return ((TreeNode)node).getData();
                }
                if (node instanceof EObject) {
                    return (EObject)node;
                }
                return null;
            }
        };
        NOT_LOADED_FRAGMENT = new Predicate<Object>(){

            public boolean apply(Object input) {
                EObject eObject = (EObject)TREE_NODE_DATA.apply(input);
                return eObject instanceof NotLoadedFragmentMatch;
            }
        };
    }

    @Before
    public void setup() {
        ArrayList factories = Lists.newArrayList();
        factories.add(new CompareItemProviderAdapterFactorySpec());
        this.eventBus = new EventBus();
        factories.add(new TreeItemProviderAdapterFactorySpec(new StructureMergeViewerFilter(this.eventBus)));
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory((Collection)factories);
        itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
    }

    private Comparison initComparison(String projectName) throws IOException, CoreException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.ui.tests");
        URL entry = bundle.getEntry("src" + SEP + "org" + SEP + "eclipse" + SEP + "emf" + SEP + "compare" + SEP + "ide" + SEP + "ui" + SEP + "tests" + SEP + "structuremergeviewer" + SEP + "notloadedfragment" + SEP + "data" + SEP + projectName + SEP + ".project");
        URL fileURL = FileLocator.toFileURL((URL)entry);
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(fileURL.getPath()));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        IFile leftFile = project.getFile((IPath)new Path("left" + SEP + "R1.ecore"));
        IFile rightFile = project.getFile((IPath)new Path("right" + SEP + "R1.ecore"));
        IFile originFile = project.getFile((IPath)new Path("origin" + SEP + "R1.ecore"));
        StorageTypedElement left = new StorageTypedElement((IStorage)leftFile, leftFile.getFullPath().toOSString());
        StorageTypedElement right = new StorageTypedElement((IStorage)rightFile, rightFile.getFullPath().toOSString());
        StorageTypedElement origin = new StorageTypedElement((IStorage)originFile, originFile.getFullPath().toOSString());
        IFile leftStorage = PlatformElementUtil.findFile((ITypedElement)left);
        if (leftStorage == null) {
            leftStorage = StreamAccessorStorage.fromTypedElement((ITypedElement)left);
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)leftStorage);
        Assert.assertTrue((boolean)(resolver instanceof ThreadedModelResolver));
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, (IModelMinimizer)EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), null);
        IComparisonScope scope = scopeBuilder.build((ITypedElement)left, (ITypedElement)right, (ITypedElement)origin, (IProgressMonitor)new NullProgressMonitor());
        Comparison comparison = EMFCompare.builder().build().compare(scope);
        return comparison;
    }

    @Test
    public void testCase0_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case0");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)2L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
    }

    @Test
    public void testCase1_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case1");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        TreeNode rootTreeNode = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"A", (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode nlfTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)nlfTreeNode));
        children = nlfTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeD = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText((Object)treeNodeD));
    }

    @Test
    public void testCase2_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case2");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
    }

    @Test
    public void testCase3_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case3");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode nodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)nodeB));
        children = nodeB.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode nlfcTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)nlfcTreeNode));
        children = nlfcTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode nodeE = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText((Object)nodeE));
    }

    @Test
    public void testCase4_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case4");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)nlfc));
        Iterator nlfcIt = nlfc.iterator();
        TreeNode r2TreeNode = (TreeNode)nlfcIt.next();
        Assert.assertEquals((Object)"[ ... ] (R2.ecore)", (Object)itemDelegator.getText((Object)r2TreeNode));
        children = r2TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
        TreeNode r3TreeNode = (TreeNode)nlfcIt.next();
        Assert.assertEquals((Object)"[ ... ] (R3.ecore)", (Object)itemDelegator.getText((Object)r3TreeNode));
        children = r3TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeC = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText((Object)treeNodeC));
    }

    @Test
    public void testCase5_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case5");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)nlfc));
        Iterator nlfcIt = nlfc.iterator();
        TreeNode r6TreeNode = (TreeNode)nlfcIt.next();
        Assert.assertEquals((Object)"[ ... ] (R6.ecore)", (Object)itemDelegator.getText((Object)r6TreeNode));
        children = r6TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeF = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText((Object)treeNodeF));
        TreeNode r7TreeNode = (TreeNode)nlfcIt.next();
        Assert.assertEquals((Object)"[ ... ] (R7.ecore)", (Object)itemDelegator.getText((Object)r7TreeNode));
        children = r7TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeG = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText((Object)treeNodeG));
    }

    @Test
    public void testCase6_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case6");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)5L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)nlfc));
        Iterator children2ndLevel = nlfc.iterator();
        TreeNode r2TreeNode = (TreeNode)children2ndLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R2.ecore)", (Object)itemDelegator.getText((Object)r2TreeNode));
        children = r2TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
        children = treeNodeB.getChildren();
        Assert.assertEquals((long)3L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)nlfc));
        Iterator children4thLevel = children.iterator();
        TreeNode treeNodeE = (TreeNode)children4thLevel.next();
        Assert.assertEquals((Object)"E [eSubpackages add]", (Object)itemDelegator.getText((Object)treeNodeE));
        TreeNode r5TreeNode = (TreeNode)children4thLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R5.ecore)", (Object)itemDelegator.getText((Object)r5TreeNode));
        children = r5TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeG = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText((Object)treeNodeG));
        TreeNode r6TreeNode = (TreeNode)children4thLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R6.ecore)", (Object)itemDelegator.getText((Object)r6TreeNode));
        children = r6TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeH = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText((Object)treeNodeH));
        TreeNode r3TreeNode = (TreeNode)children2ndLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R3.ecore)", (Object)itemDelegator.getText((Object)r3TreeNode));
        children = r3TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeC = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText((Object)treeNodeC));
    }

    @Test
    public void testCase7_DefaultGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case7");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)4L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)3L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)nlfc));
        Iterator children2ndLevel = nlfc.iterator();
        TreeNode r3TreeNode = (TreeNode)children2ndLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R3.ecore)", (Object)itemDelegator.getText((Object)r3TreeNode));
        children = r3TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeC = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText((Object)treeNodeC));
        TreeNode r5TreeNode = (TreeNode)children2ndLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R5.ecore)", (Object)itemDelegator.getText((Object)r5TreeNode));
        children = r5TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeG = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText((Object)treeNodeG));
        TreeNode r6TreeNode = (TreeNode)children2ndLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R6.ecore)", (Object)itemDelegator.getText((Object)r6TreeNode));
        children = r6TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeH = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText((Object)treeNodeH));
    }

    @Test
    public void testCase0_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case0");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)1L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)nlfc));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode nlfTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)nlfTreeNode));
        children = nlfTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
    }

    @Test
    public void testCase1_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case1");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)2L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)nlfc));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)3L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)nlfc));
        TreeNode treeNodeA = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"A", (Object)itemDelegator.getText((Object)treeNodeA));
        children = treeNodeA.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode nlfTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)nlfTreeNode));
        children = nlfTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeD = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText((Object)treeNodeD));
    }

    @Test
    public void testCase2_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case2");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)2L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)nlfc));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)3L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
    }

    @Test
    public void testCase3_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case3");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)2L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)nlfc));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)3L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode nodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)nodeB));
        children = nodeB.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode nlfcTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)nlfcTreeNode));
        children = nlfcTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode nodeE = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText((Object)nodeE));
    }

    @Test
    public void testCase4_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case4");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeC = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText((Object)treeNodeC));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)3L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
    }

    @Test
    public void testCase5_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case5");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeF = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText((Object)treeNodeF));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)3L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeG = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText((Object)treeNodeG));
    }

    @Test
    public void testCase6_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case6");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)5L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeB = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText((Object)treeNodeB));
        children = treeNodeB.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        Iterator children4thLevel = children.iterator();
        TreeNode treeNodeE = (TreeNode)children4thLevel.next();
        Assert.assertEquals((Object)"E [eSubpackages add]", (Object)itemDelegator.getText((Object)treeNodeE));
        TreeNode r5TreeNode = (TreeNode)children4thLevel.next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)r5TreeNode));
        children = r5TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeG = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText((Object)treeNodeG));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)5L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)nlfc));
        Iterator children3rdLevel = nlfc.iterator();
        TreeNode r3TreeNode = (TreeNode)children3rdLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R3.ecore)", (Object)itemDelegator.getText((Object)r3TreeNode));
        children = r3TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeC = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText((Object)treeNodeC));
        TreeNode r6TreeNode = (TreeNode)children3rdLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R6.ecore)", (Object)itemDelegator.getText((Object)r6TreeNode));
        children = r6TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeH = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText((Object)treeNodeH));
    }

    @Test
    public void testCase7_3wayGroupProvider() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case7");
        TreeNode groupTreeNode = TreeFactory.eINSTANCE.createTreeNode();
        groupTreeNode.setData((EObject)comparison);
        groupTreeNode.eAdapters().add((Object)new ThreeWayComparisonGroupProvider());
        Collection children = itemDelegator.getChildren((Object)groupTreeNode);
        Assert.assertEquals((long)3L, (long)children.size());
        Iterator children1stLevel = children.iterator();
        GroupItemProviderAdapter conflicts = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)CONFLICTS, (Object)itemDelegator.getText((Object)conflicts));
        children = conflicts.getChildren(null);
        Assert.assertEquals((long)0L, (long)children.size());
        GroupItemProviderAdapter leftSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)LEFT_SIDE, (Object)itemDelegator.getText((Object)leftSide));
        children = leftSide.getChildren(null);
        Assert.assertEquals((long)4L, (long)children.size());
        Iterable nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        TreeNode rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeG = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText((Object)treeNodeG));
        GroupItemProviderAdapter rightSide = (GroupItemProviderAdapter)children1stLevel.next();
        Assert.assertEquals((Object)RIGHT_SIDE, (Object)itemDelegator.getText((Object)rightSide));
        children = rightSide.getChildren(null);
        Assert.assertEquals((long)4L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nlfc));
        rootTreeNode = (TreeNode)nlfc.iterator().next();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText((Object)rootTreeNode));
        children = rootTreeNode.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        nlfc = Iterables.filter((Iterable)children, NOT_LOADED_FRAGMENT);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)nlfc));
        Iterator children3rdLevel = nlfc.iterator();
        TreeNode r3TreeNode = (TreeNode)children3rdLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R3.ecore)", (Object)itemDelegator.getText((Object)r3TreeNode));
        children = r3TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeC = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText((Object)treeNodeC));
        TreeNode r6TreeNode = (TreeNode)children3rdLevel.next();
        Assert.assertEquals((Object)"[ ... ] (R6.ecore)", (Object)itemDelegator.getText((Object)r6TreeNode));
        children = r6TreeNode.getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
        TreeNode treeNodeH = (TreeNode)children.iterator().next();
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText((Object)treeNodeH));
    }
}

