/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ByResourceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.KindGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ThreeWayComparisonGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchResourceNode;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.data.nodes.resourceattachmentchange.ResourceAttachmentChangeInGroupsInputData;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.edit.tree.TreeNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceAttachmentChangeInGroupsTest
extends AbstractTestTreeNodeItemProviderAdapter {
    private Comparison comp;

    @Before
    public void setUp() throws Exception {
        this.comp = ResourceAttachmentChangeInGroupsTest.getComparison(new ResourceAttachmentChangeInGroupsInputData());
    }

    @Test
    public void testResourceAttachmentChangeInThreeWayComparisonGroupProvider() {
        ThreeWayComparisonGroupProvider threeWayComparisonGroup = new ThreeWayComparisonGroupProvider();
        Collection groups = threeWayComparisonGroup.getGroups(this.comp);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)3L, (long)groups.size());
        IDifferenceGroup[] groupsArray = groups.toArray(new IDifferenceGroup[3]);
        IDifferenceGroup conflictsGroup = groupsArray[0];
        Assert.assertEquals((Object)EMFCompareRCPUIMessages.getString((String)"ThreeWayComparisonGroupProvider.conflicts.label"), (Object)conflictsGroup.getName());
        List children = conflictsGroup.getChildren();
        Assert.assertEquals((long)0L, (long)children.size());
        IDifferenceGroup leftGroup = groupsArray[1];
        Assert.assertEquals((Object)EMFCompareRCPUIMessages.getString((String)"ThreeWayComparisonGroupProvider.left.label"), (Object)leftGroup.getName());
        children = leftGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        TreeNode fragmentMatchResourceNode = (TreeNode)children.get(0);
        EList fragmentMatchResourceNodeChildren = fragmentMatchResourceNode.getChildren();
        Assert.assertEquals((long)1L, (long)fragmentMatchResourceNodeChildren.size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeChildren, DiffNode.class)));
        Iterable fragmentMatchResourceNodeData = Iterables.transform((Iterable)fragmentMatchResourceNodeChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)fragmentMatchResourceNodeData));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeData, ResourceAttachmentChange.class)));
        TreeNode rootMatchResourceNode = (TreeNode)children.get(1);
        Assert.assertEquals((long)0L, (long)rootMatchResourceNode.getChildren().size());
        IDifferenceGroup rightGroup = groupsArray[2];
        Assert.assertEquals((Object)EMFCompareRCPUIMessages.getString((String)"ThreeWayComparisonGroupProvider.right.label"), (Object)rightGroup.getName());
        children = rightGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        for (TreeNode treeNode : children) {
            children = treeNode.getChildren();
            Assert.assertEquals((long)0L, (long)children.size());
        }
    }

    @Test
    public void testResourceAttachmentChangeInDefaultComparisonGroupProvider() {
        DefaultGroupProvider defaultComparisonGroup = new DefaultGroupProvider();
        Collection groups = defaultComparisonGroup.getGroups(this.comp);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)1L, (long)groups.size());
        IDifferenceGroup defaultGroup = (IDifferenceGroup)groups.iterator().next();
        List children = defaultGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        TreeNode fragmentMatchResourceNode = (TreeNode)children.get(0);
        EList fragmentMatchResourceNodeChildren = fragmentMatchResourceNode.getChildren();
        Assert.assertEquals((long)1L, (long)fragmentMatchResourceNodeChildren.size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeChildren, DiffNode.class)));
        Iterable fragmentMatchResourceNodeData = Iterables.transform((Iterable)fragmentMatchResourceNodeChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)fragmentMatchResourceNodeData));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeData, ResourceAttachmentChange.class)));
        TreeNode rootMatchResourceNode = (TreeNode)children.get(1);
        Assert.assertEquals((long)0L, (long)rootMatchResourceNode.getChildren().size());
    }

    @Test
    public void testResourceAttachmentChangeInByKindComparisonGroupProvider() {
        KindGroupProvider kindComparisonGroup = new KindGroupProvider();
        Collection groups = kindComparisonGroup.getGroups(this.comp);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)4L, (long)groups.size());
        IDifferenceGroup[] groupsArray = groups.toArray(new IDifferenceGroup[4]);
        IDifferenceGroup additionGroup = groupsArray[0];
        Assert.assertEquals((Object)EMFCompareRCPUIMessages.getString((String)"KindGroupProvider.addition.label"), (Object)additionGroup.getName());
        List children = additionGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        for (TreeNode treeNode : children) {
            children = treeNode.getChildren();
            Assert.assertEquals((long)0L, (long)children.size());
        }
        IDifferenceGroup deletionGroup = groupsArray[1];
        Assert.assertEquals((Object)EMFCompareRCPUIMessages.getString((String)"KindGroupProvider.deletion.label"), (Object)deletionGroup.getName());
        children = deletionGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        TreeNode fragmentMatchResourceNode = (TreeNode)children.get(0);
        EList fragmentMatchResourceNodeChildren = fragmentMatchResourceNode.getChildren();
        Assert.assertEquals((long)1L, (long)fragmentMatchResourceNodeChildren.size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeChildren, DiffNode.class)));
        Iterable fragmentMatchResourceNodeData = Iterables.transform((Iterable)fragmentMatchResourceNodeChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)fragmentMatchResourceNodeData));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeData, ResourceAttachmentChange.class)));
        TreeNode rootMatchResourceNode = (TreeNode)children.get(1);
        Assert.assertEquals((long)0L, (long)rootMatchResourceNode.getChildren().size());
        IDifferenceGroup changeGroup = groupsArray[2];
        Assert.assertEquals((Object)EMFCompareRCPUIMessages.getString((String)"KindGroupProvider.change.label"), (Object)changeGroup.getName());
        children = changeGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        for (TreeNode treeNode : children) {
            children = treeNode.getChildren();
            Assert.assertEquals((long)0L, (long)children.size());
        }
        IDifferenceGroup moveGroup = groupsArray[3];
        Assert.assertEquals((Object)EMFCompareRCPUIMessages.getString((String)"KindGroupProvider.move.label"), (Object)moveGroup.getName());
        children = moveGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        for (TreeNode treeNode : children) {
            children = treeNode.getChildren();
            Assert.assertEquals((long)0L, (long)children.size());
        }
    }

    @Test
    public void testResourceAttachmentChangeInByResourceComparisonGroupProvider() {
        ByResourceGroupProvider resourceComparisonGroup = new ByResourceGroupProvider();
        Collection groups = resourceComparisonGroup.getGroups(this.comp);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)1L, (long)groups.size());
        IDifferenceGroup byResourceGroup = (IDifferenceGroup)groups.iterator().next();
        List children = byResourceGroup.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)children, MatchResourceNode.class)));
        TreeNode fragmentMatchResourceNode = (TreeNode)children.get(0);
        EList fragmentMatchResourceNodeChildren = fragmentMatchResourceNode.getChildren();
        Assert.assertEquals((long)1L, (long)fragmentMatchResourceNodeChildren.size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeChildren, DiffNode.class)));
        Iterable fragmentMatchResourceNodeData = Iterables.transform((Iterable)fragmentMatchResourceNodeChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)fragmentMatchResourceNodeData));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)fragmentMatchResourceNodeData, ResourceAttachmentChange.class)));
        TreeNode rootMatchResourceNode = (TreeNode)children.get(1);
        Assert.assertEquals((long)0L, (long)rootMatchResourceNode.getChildren().size());
    }
}

