/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.models;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.emf.compare.ide.ui.tests.egit.CompareGitTestCase;
import org.eclipse.emf.compare.ide.ui.tests.egit.fixture.GitTestRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Assert;
import org.junit.Before;

public abstract class ModelTestCase
extends CompareGitTestCase {
    protected static final String SAMPLE_FILE_EXTENSION = "sample";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        IContentType textType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        textType.addFileSpec(SAMPLE_FILE_EXTENSION, 8);
    }

    protected RevCommit setContentsAndCommit(GitTestRepository testRepository, IFile targetFile, String newContents, String commitMessage) throws Exception {
        targetFile.setContents((InputStream)new ByteArrayInputStream(newContents.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
        testRepository.addToIndex((IResource)targetFile);
        return testRepository.commit(commitMessage);
    }

    protected void assertContentEquals(IFile file, String expectedContents) throws Exception {
        try (Scanner scanner = new Scanner(file.getContents());){
            scanner.useDelimiter("\\A");
            String fileContent = "";
            if (scanner.hasNext()) {
                fileContent = scanner.next();
            }
            Assert.assertEquals((Object)expectedContents, (Object)fileContent);
        }
    }

    protected void merge(Repository repo, String refName) throws CoreException {
        new MergeOperation(repo, refName).execute(null);
    }

    protected void merge(Repository repo, String refName, String strategyName) throws CoreException {
        new MergeOperation(repo, refName, strategyName).execute(null);
    }

    protected Status status(Repository repo) throws Exception {
        try (Git git = new Git(repo);){
            Status status = git.status().call();
            return status;
        }
    }
}

