/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceFilterManager {
    private static final String BY_DEFAULT_DISABLED_FILTER = "org.eclipse.emf.compare.rcp.ui.filters.disabled";
    private final Map<String, DifferenceFilterDefaultConfiguration> map = Collections.synchronizedMap(new LinkedHashMap());
    private final Preferences preferenceStore;
    private static final Function<DifferenceFilterDefaultConfiguration, IDifferenceFilter> TO_FILTER = new Function<DifferenceFilterDefaultConfiguration, IDifferenceFilter>(){

        public IDifferenceFilter apply(DifferenceFilterDefaultConfiguration arg0) {
            if (arg0 != null) {
                return arg0.getFilter();
            }
            return null;
        }
    };

    public DifferenceFilterManager(Preferences preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    IDifferenceFilter add(IDifferenceFilter filter) {
        Preconditions.checkNotNull((Object)filter);
        DifferenceFilterDefaultConfiguration oldValue = this.map.put(filter.getClass().getName(), new DifferenceFilterDefaultConfiguration(filter, filter.defaultSelected()));
        if (oldValue != null) {
            return oldValue.getFilter();
        }
        return null;
    }

    IDifferenceFilter remove(String className) {
        DifferenceFilterDefaultConfiguration oldValue = this.map.remove(className);
        if (oldValue != null) {
            return oldValue.getFilter();
        }
        return null;
    }

    public Set<IDifferenceFilter> getCurrentByDefaultFilters() {
        Set<IDifferenceFilter> storedFilter = this.getDisabledFilters();
        if (storedFilter == null) {
            return this.getInitialByDefaultFilters();
        }
        return Sets.difference(this.getAllFilters(), storedFilter);
    }

    public Set<IDifferenceFilter> getInitialByDefaultFilters() {
        Collection enableFilter = Collections2.filter(this.map.values(), (Predicate)new Predicate<DifferenceFilterDefaultConfiguration>(){

            public boolean apply(DifferenceFilterDefaultConfiguration arg0) {
                return arg0.isDefaultSelectedInitialValue();
            }
        });
        return Sets.newLinkedHashSet((Iterable)Collections2.transform((Collection)enableFilter, TO_FILTER));
    }

    public void setCurrentByDefaultFilters(Set<IDifferenceFilter> enabledFilter) {
        Sets.SetView disableFilter = enabledFilter == null ? this.getAllFilters() : Sets.difference(this.getAllFilters(), enabledFilter);
        Sets.SetView initialDisabledFilter = Sets.difference(this.getAllFilters(), this.getInitialByDefaultFilters());
        this.storeInPreferences((Set<IDifferenceFilter>)disableFilter, (Set<IDifferenceFilter>)initialDisabledFilter);
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder builder = new StringBuilder();
            builder.append("Preference ").append(BY_DEFAULT_DISABLED_FILTER).append(":\n");
            String preferenceValue = this.preferenceStore.get(BY_DEFAULT_DISABLED_FILTER, "");
            String[] groups = preferenceValue.split(";");
            int rank = 0;
            while (rank < groups.length) {
                builder.append(rank).append(". ").append(groups[rank]).append("\n");
                ++rank;
            }
            builder.append("\n\n");
            EMFCompareRCPUIPlugin.getDefault().log(1, builder.toString());
        }
    }

    public Set<IDifferenceFilter> getAllFilters() {
        return Sets.newLinkedHashSet((Iterable)Collections2.transform(this.map.values(), TO_FILTER));
    }

    private Set<IDifferenceFilter> getDisabledFilters() {
        String diffEngineKey = this.preferenceStore.get(BY_DEFAULT_DISABLED_FILTER, null);
        LinkedHashSet<IDifferenceFilter> result = null;
        if (diffEngineKey != null) {
            String[] diffEngineKeys;
            String[] stringArray = diffEngineKeys = diffEngineKey.split(";");
            int n = diffEngineKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String nonTrimedKey = stringArray[n2];
                String key = nonTrimedKey.trim();
                DifferenceFilterDefaultConfiguration descriptor = this.map.get(key);
                if (descriptor != null) {
                    if (result == null) {
                        result = new LinkedHashSet<IDifferenceFilter>();
                    }
                    result.add(descriptor.getFilter());
                }
                ++n2;
            }
        }
        return result;
    }

    private void storeInPreferences(Set<IDifferenceFilter> currentValue, Set<IDifferenceFilter> defaultConf) {
        if (currentValue != null && !currentValue.equals(defaultConf)) {
            Map toStore = Maps.filterValues((Map)Maps.transformValues(this.map, TO_FILTER), (Predicate)Predicates.in(currentValue));
            String preferenceValue = Joiner.on((String)";").join(toStore.keySet());
            this.preferenceStore.put(BY_DEFAULT_DISABLED_FILTER, preferenceValue);
        } else {
            this.preferenceStore.remove(BY_DEFAULT_DISABLED_FILTER);
        }
    }

    public void clear() {
        this.map.clear();
    }

    private static class DifferenceFilterDefaultConfiguration {
        private IDifferenceFilter filter;
        private boolean isDefaultSelectedInitialValue;

        public DifferenceFilterDefaultConfiguration(IDifferenceFilter filter, boolean isByDefaultSelected) {
            this.filter = filter;
            this.isDefaultSelectedInitialValue = isByDefaultSelected;
        }

        public IDifferenceFilter getFilter() {
            return this.filter;
        }

        public boolean isDefaultSelectedInitialValue() {
            return this.isDefaultSelectedInitialValue;
        }
    }
}

