/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.command.impl.AbstractCopyCommand;
import org.eclipse.emf.compare.internal.domain.IMergeAllNonConflictingRunnable;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class MergeAllNonConflictingCommand
extends AbstractCopyCommand {
    private final Comparison comparison;
    private List<Diff> affectedDiffs;
    private IMergeAllNonConflictingRunnable runnable;

    public MergeAllNonConflictingCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, Comparison comparison, boolean leftToRight, IMerger.Registry mergerRegistry, IMergeAllNonConflictingRunnable runnable) {
        super(changeRecorder, notifiers, MergeAllNonConflictingCommand.getDifferencesToMerge(comparison, leftToRight), leftToRight, mergerRegistry);
        this.comparison = comparison;
        this.runnable = runnable;
    }

    protected void doExecute() {
        this.runnable.merge(this.comparison, this.isLeftToRight(), this.mergerRegistry);
    }

    @Override
    public Collection<?> getAffectedObjects() {
        if (this.affectedDiffs == null) {
            return Collections.emptyList();
        }
        return this.affectedDiffs;
    }

    private static List<Diff> getDifferencesToMerge(Comparison comparison, boolean leftToRight) {
        Iterable diffs = leftToRight ? Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)) : Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        return Lists.newArrayList((Iterable)diffs);
    }
}

