/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor.extension.stereotype;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.internal.StereotypedElementChange;
import org.eclipse.emf.compare.uml2.internal.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.internal.postprocessor.AbstractUMLChangeFactory;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLStereotypedElementChangeFactory
extends AbstractUMLChangeFactory {
    public Class<? extends Diff> getExtensionKind() {
        return StereotypedElementChange.class;
    }

    @Override
    public boolean handles(Diff input) {
        ReferenceChange refChange;
        if (input instanceof ReferenceChange && (refChange = (ReferenceChange)input).getReference().isContainment() && refChange.getValue() instanceof Element && (refChange.getKind() == DifferenceKind.ADD || refChange.getKind() == DifferenceKind.DELETE)) {
            return !this.getStereotypeApplicationChanges(refChange).isEmpty();
        }
        return false;
    }

    private List<StereotypeApplicationChange> getStereotypeApplicationChanges(ReferenceChange refChange) {
        EList searchScope;
        ArrayList result = Lists.newArrayList();
        switch (refChange.getKind()) {
            case ADD: {
                searchScope = refChange.getRequiredBy();
                break;
            }
            case DELETE: {
                searchScope = refChange.getRequires();
                break;
            }
            default: {
                searchScope = Collections.emptyList();
            }
        }
        for (Diff reqBy : searchScope) {
            if (!(reqBy instanceof StereotypeApplicationChange)) continue;
            StereotypeApplicationChange stereoAppChange = (StereotypeApplicationChange)reqBy;
            if (!refChange.getValue().equals(UMLCompareUtil.getBaseElement(stereoAppChange.getDiscriminant()))) continue;
            result.add(stereoAppChange);
        }
        return result;
    }

    public Diff createExtension() {
        return UMLCompareFactory.eINSTANCE.createStereotypedElementChange();
    }

    @Override
    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        List<StereotypeApplicationChange> stereotypeApplicationChanges = this.getStereotypeApplicationChanges((ReferenceChange)refiningDiff);
        extension.getRefinedBy().addAll(stereotypeApplicationChanges);
        extension.getRefinedBy().add((Object)refiningDiff);
    }

    @Override
    protected Switch<Set<EObject>> getDiscriminantsGetter() {
        return null;
    }

    @Override
    protected EObject getDiscriminant(Diff input) {
        return ((ReferenceChange)input).getValue();
    }
}

