/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions;

import java.util.Collection;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.FilterAction;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FilterActionMenu
extends Action
implements IMenuCreator {
    private final StructureMergeViewerFilter structureMergeViewerFilter;
    private final MenuManager menuManager;
    private final IDifferenceFilter.Registry registry;

    public FilterActionMenu(StructureMergeViewerFilter structureMergeViewerFilter, IDifferenceFilter.Registry registry) {
        super("", 4);
        this.structureMergeViewerFilter = structureMergeViewerFilter;
        this.registry = registry;
        this.menuManager = new MenuManager();
        this.setMenuCreator(this);
        this.setToolTipText("Filters");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.rcp.ui", (String)"icons/full/toolb16/filter.gif"));
    }

    public void updateMenu(IComparisonScope newScope, Comparison newComparison) {
        this.menuManager.removeAll();
        Collection<IDifferenceFilter> filters = this.registry.getFilters(newScope, newComparison);
        for (IDifferenceFilter filter : filters) {
            FilterAction action = new FilterAction(filter.getLabel(), this.structureMergeViewerFilter, filter);
            boolean selected = this.structureMergeViewerFilter.getSelectedDifferenceFilters().contains(filter);
            action.setChecked(selected);
            this.menuManager.add((IAction)action);
        }
    }

    public void dispose() {
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        return this.menuManager.createContextMenu(parent);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

