/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.postprocessor.factories;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChangeFactory
implements IChangeFactory {
    private CompareSwitch<DifferenceKind> differenceKindCompareSwitch = new DifferenceKindCompareSwitch();

    @Override
    public boolean handles(Diff input) {
        return this.getRelatedExtensionKind(input) != null;
    }

    @Override
    public Diff create(Diff input) {
        Diff ret = this.createExtension();
        DifferenceKind extensionKind = this.getRelatedExtensionKind(input);
        ret.setKind(extensionKind);
        this.setRefiningChanges(ret, extensionKind, input);
        ret.setSource(input.getSource());
        Diff conflictingDiff = (Diff)Iterators.find((Iterator)ret.getRefinedBy().iterator(), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                return difference.getConflict() != null;
            }
        }, null);
        if (conflictingDiff != null) {
            ret.setConflict(conflictingDiff.getConflict());
        }
        return ret;
    }

    public abstract Diff createExtension();

    public abstract void setRefiningChanges(Diff var1, DifferenceKind var2, Diff var3);

    @Override
    public Match getParentMatch(Diff input) {
        return input.getMatch();
    }

    @Override
    public Class<? extends Diff> getExtensionKind() {
        return Diff.class;
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
        HashSet<Diff> requiredExtensions = new HashSet<Diff>();
        HashSet<Diff> requiringExtensions = new HashSet<Diff>();
        for (Diff refiningDiff : extension.getRefinedBy()) {
            requiredExtensions.addAll(this.getDistinctRefinedDifferences((List<Diff>)refiningDiff.getRequires()));
            requiringExtensions.addAll(this.getDistinctRefinedDifferences((List<Diff>)refiningDiff.getRequiredBy()));
        }
        requiredExtensions.remove(extension);
        requiringExtensions.remove(extension);
        extension.getRequires().addAll(requiredExtensions);
        extension.getRequiredBy().addAll(requiringExtensions);
    }

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return this.differenceKindCompareSwitch.doSwitch(input);
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ResourceAttachmentChange input) {
        return false;
    }

    protected Set<Diff> getAllContainedDifferences(Diff input) {
        HashSet<Diff> result = new HashSet<Diff>();
        Comparison comparison = input.getMatch().getComparison();
        CompareSwitch<EObject> valueGetter = new CompareSwitch<EObject>(){

            @Override
            public EObject caseReferenceChange(ReferenceChange object) {
                return object.getValue();
            }

            @Override
            public EObject caseResourceAttachmentChange(ResourceAttachmentChange object) {
                return MatchUtil.getContainer(object.getMatch().getComparison(), object);
            }

            @Override
            public EObject defaultCase(EObject object) {
                return null;
            }
        };
        EObject value = (EObject)valueGetter.doSwitch(input);
        if (value != null) {
            Match match = comparison.getMatch(value);
            result.addAll(this.getAllContainedDifferences(comparison, match));
        }
        return result;
    }

    protected final List<Diff> findCrossReferences(Comparison comparison, EObject lookup, Predicate<Diff> p) {
        ArrayList<Diff> result = new ArrayList<Diff>();
        for (Diff diff : comparison.getDifferences(lookup)) {
            if (!p.apply((Object)diff)) continue;
            result.add(diff);
        }
        return result;
    }

    private Set<Diff> getAllContainedDifferences(Comparison comparison, Match match) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        LinkedHashSet prune = Sets.newLinkedHashSet();
        for (Diff candidate : match.getDifferences()) {
            if (this.getExtensionKind().isInstance(candidate)) continue;
            if (this.getRelatedExtensionKind(candidate) == null) {
                result.add(candidate);
                continue;
            }
            if (!(candidate instanceof ReferenceChange) || !((ReferenceChange)candidate).getReference().isContainment()) continue;
            prune.add(comparison.getMatch(((ReferenceChange)candidate).getValue()));
        }
        for (Match submatch : match.getSubmatches()) {
            if (prune.contains(submatch)) continue;
            result.addAll(this.getAllContainedDifferences(comparison, submatch));
        }
        return result;
    }

    private Set<Diff> getDistinctRefinedDifferences(List<Diff> refiningDifferences) {
        Iterator<Diff> unitDiffs = refiningDifferences.iterator();
        HashSet<Diff> extensions = new HashSet<Diff>();
        while (unitDiffs.hasNext()) {
            Diff unitDiff = unitDiffs.next();
            extensions.addAll((Collection<Diff>)unitDiff.getRefines());
        }
        return extensions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DifferenceKindCompareSwitch
    extends CompareSwitch<DifferenceKind> {
        private DifferenceKindCompareSwitch() {
        }

        @Override
        public DifferenceKind caseAttributeChange(AttributeChange object) {
            DifferenceKind result = AbstractChangeFactory.this.isRelatedToAnExtensionAdd(object) ? DifferenceKind.ADD : (AbstractChangeFactory.this.isRelatedToAnExtensionDelete(object) ? DifferenceKind.DELETE : (AbstractChangeFactory.this.isRelatedToAnExtensionChange(object) ? DifferenceKind.CHANGE : (AbstractChangeFactory.this.isRelatedToAnExtensionMove(object) ? DifferenceKind.MOVE : (DifferenceKind)((Object)super.caseAttributeChange(object)))));
            return result;
        }

        @Override
        public DifferenceKind caseReferenceChange(ReferenceChange object) {
            DifferenceKind result = AbstractChangeFactory.this.isRelatedToAnExtensionAdd(object) ? DifferenceKind.ADD : (AbstractChangeFactory.this.isRelatedToAnExtensionDelete(object) ? DifferenceKind.DELETE : (AbstractChangeFactory.this.isRelatedToAnExtensionChange(object) ? DifferenceKind.CHANGE : (AbstractChangeFactory.this.isRelatedToAnExtensionMove(object) ? DifferenceKind.MOVE : (DifferenceKind)((Object)super.caseReferenceChange(object)))));
            return result;
        }

        @Override
        public DifferenceKind caseResourceAttachmentChange(ResourceAttachmentChange object) {
            DifferenceKind result = AbstractChangeFactory.this.isRelatedToAnExtensionAdd(object) ? DifferenceKind.ADD : (AbstractChangeFactory.this.isRelatedToAnExtensionDelete(object) ? DifferenceKind.DELETE : (AbstractChangeFactory.this.isRelatedToAnExtensionChange(object) ? DifferenceKind.CHANGE : (AbstractChangeFactory.this.isRelatedToAnExtensionMove(object) ? DifferenceKind.MOVE : (DifferenceKind)((Object)super.caseResourceAttachmentChange(object)))));
            return result;
        }
    }
}

