/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionUnchunker;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringIO;

public abstract class CDOServerRequest
extends Request {
    public CDOServerRequest(CDOServerProtocol serverProtocol, short signalID) {
        super((SignalProtocol)serverProtocol, signalID);
    }

    public CDOServerProtocol getProtocol() {
        return (CDOServerProtocol)super.getProtocol();
    }

    protected InternalSession getSession() {
        return this.getProtocol().getSession();
    }

    protected String getAdditionalInfo() {
        String additionalInfo = super.getAdditionalInfo();
        String userID = this.getSession().getUserID();
        if (userID != null) {
            additionalInfo = String.valueOf(additionalInfo) + ", user=" + userID;
        }
        return additionalInfo;
    }

    protected final void requesting(ExtendedDataOutputStream out) throws Exception {
        this.requesting((CDODataOutput)new CDODataOutputImpl((ExtendedDataOutput)out){

            public InternalSession getSession() {
                return CDOServerRequest.this.getSession();
            }

            public CDOPackageRegistry getPackageRegistry() {
                return this.getSession().getRepository().getPackageRegistry();
            }

            public CDORevisionUnchunker getRevisionUnchunker() {
                return this.getSession().getRepository();
            }

            protected boolean isXCompression() {
                return CDOProtocolConstants.X_COMPRESSION;
            }

            protected StringIO getPackageURICompressor() {
                return CDOServerRequest.this.getProtocol().getPackageURICompressor();
            }

            public CDOIDProvider getIDProvider() {
                return this.getSession();
            }
        });
    }

    protected abstract void requesting(CDODataOutput var1) throws IOException;
}

