/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.chat;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

public interface ChatMessage
extends Comparable<ChatMessage> {
    public int getID();

    public Author getAuthor();

    public long getCreationTime();

    public long getEditTime();

    public String getContent();

    public ChatMessage getReplyTo();

    @Override
    default public int compareTo(ChatMessage o) {
        return Long.compare(this.getCreationTime(), o.getCreationTime());
    }

    public static final class Author
    implements Serializable,
    Comparable<Author> {
        private static final long serialVersionUID = 1L;
        private final String userID;
        private final String firstName;
        private final String lastName;
        private final String fullName;
        private final String initials;
        private final URI avatar;

        private Author(String userID, String firstName, String lastName, URI avatar) {
            this.userID = userID;
            this.firstName = firstName;
            this.lastName = lastName;
            this.fullName = (String)(firstName == null ? "" : firstName + " ") + lastName;
            this.initials = ((firstName == null ? "" : firstName.substring(0, 1)) + lastName.substring(0, 1)).toUpperCase();
            this.avatar = avatar;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getShortName() {
            return this.firstName == null ? this.lastName : this.firstName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInitials() {
            return this.initials;
        }

        public URI getAvatar() {
            return this.avatar;
        }

        @Override
        public int compareTo(Author o) {
            return this.userID.compareTo(o.userID);
        }

        public int hashCode() {
            return Objects.hash(this.userID);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Author other = (Author)obj;
            return Objects.equals(this.userID, other.userID);
        }

        public String toString() {
            return "Author[" + this.userID + "]";
        }

        public static Builder builder(String userID) {
            return new Builder(userID);
        }

        public static final class Builder {
            private static final MessageDigest SHA_256;
            private final String userID;
            private String firstName;
            private String lastName;
            private URI avatar;

            static {
                MessageDigest digest;
                try {
                    digest = MessageDigest.getInstance("SHA-256");
                }
                catch (Throwable ex) {
                    OM.LOG.warn(ex);
                    digest = null;
                }
                SHA_256 = digest;
            }

            public Builder(String userID) {
                CheckUtil.checkArg((!StringUtil.isEmpty((String)userID) ? 1 : 0) != 0, (String)"userID");
                this.userID = userID;
            }

            public Builder firstName(String firstName) {
                this.firstName = firstName;
                return this;
            }

            public Builder lastName(String lastName) {
                this.lastName = lastName;
                return this;
            }

            public Builder avatar(URI avatar) {
                this.avatar = avatar;
                return this;
            }

            public Builder avatar(File avatar) {
                return this.avatar(avatar.toURI());
            }

            public Builder gravatar(String email) {
                CheckUtil.checkArg((!StringUtil.isEmpty((String)email) ? 1 : 0) != 0, (String)"email");
                return this.avatar(URI.create("https://www.gravatar.com/avatar/" + Builder.sha256(email.toLowerCase())));
            }

            public Author build() {
                String lastName;
                String firstName = this.firstName;
                if (StringUtil.isEmpty((String)firstName)) {
                    firstName = null;
                }
                if (StringUtil.isEmpty((String)(lastName = this.lastName))) {
                    lastName = this.userID;
                }
                return new Author(this.userID, firstName, lastName, this.avatar);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static String sha256(String string) {
                byte[] hash;
                CheckUtil.checkState((Object)SHA_256, (String)"SHA_256");
                MessageDigest messageDigest = SHA_256;
                synchronized (messageDigest) {
                    hash = SHA_256.digest(string.getBytes(StandardCharsets.UTF_8));
                }
                return HexUtil.bytesToHex((byte[])hash);
            }
        }

        public static final class Cache {
            private static final Map<Object, Cache> CACHES = new WeakHashMap<Object, Cache>();
            private final Map<String, Author> authors = new ConcurrentHashMap<String, Author>();
            private final Function<Iterable<String>, Map<String, Author>> authorsLoader;

            public Cache(Function<Iterable<String>, Map<String, Author>> authorsLoader) {
                this.authorsLoader = authorsLoader;
            }

            public Author getAuthor(String userID) {
                Map<String, Author> loadedAuthors;
                Author author = this.authors.get(userID);
                if (author == null && (author = (loadedAuthors = this.authorsLoader.apply(Collections.singleton(userID))).get(userID)) != null) {
                    this.authors.put(userID, author);
                }
                return author;
            }

            public Map<String, Author> getAuthors(Iterable<String> userIDs) {
                Map<String, Author> loadedAuthors;
                HashMap<String, Author> result = new HashMap<String, Author>();
                ArrayList<String> userIDsToLoad = null;
                for (String userID : userIDs) {
                    Author author = this.authors.get(userID);
                    if (author != null) {
                        result.put(userID, author);
                        continue;
                    }
                    if (userIDsToLoad == null) {
                        userIDsToLoad = new ArrayList<String>();
                    }
                    userIDsToLoad.add(userID);
                }
                if (userIDsToLoad != null && (loadedAuthors = this.authorsLoader.apply(userIDsToLoad)) != null) {
                    this.authors.putAll(loadedAuthors);
                    result.putAll(loadedAuthors);
                }
                return result;
            }

            public static Cache of(Object object, Function<Iterable<String>, Map<String, Author>> authorsLoader) {
                return Cache.of(object, () -> authorsLoader);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Cache of(Object object, Supplier<Function<Iterable<String>, Map<String, Author>>> authorsLoaderSupplier) {
                Map<Object, Cache> map = CACHES;
                synchronized (map) {
                    return CACHES.computeIfAbsent(object, k -> {
                        Cache cache = new Cache((Function)authorsLoaderSupplier.get());
                        if (object instanceof ILifecycle) {
                            ((ILifecycle)object).addListener((IListener)new LifecycleEventAdapter(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                protected void onDeactivated(ILifecycle lifecycle) {
                                    Map<Object, Cache> map = CACHES;
                                    synchronized (map) {
                                        CACHES.remove(lifecycle);
                                    }
                                }
                            });
                        }
                        return cache;
                    });
                }
            }
        }
    }

    @FunctionalInterface
    public static interface Provider {
        public ChatMessage[] getMessages();
    }
}

